/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.http.netty.utils.client;

import io.netty.bootstrap.Bootstrap;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.handler.codec.http2.DefaultHttp2DataFrame;
import io.netty.handler.codec.http2.DefaultHttp2Headers;
import io.netty.handler.codec.http2.DefaultHttp2HeadersFrame;
import io.netty.handler.codec.http2.Http2Frame;
import io.netty.handler.codec.http2.Http2Headers;
import io.netty.handler.codec.http2.Http2HeadersFrame;
import io.netty.handler.ssl.ApplicationProtocolConfig;
import io.netty.handler.ssl.CipherSuiteFilter;
import io.netty.handler.ssl.IdentityCipherSuiteFilter;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslContextBuilder;
import io.netty.handler.ssl.SslProvider;
import io.netty.handler.ssl.util.InsecureTrustManagerFactory;
import java.util.concurrent.TimeUnit;
import org.junit.rules.ExternalResource;
import org.mule.runtime.http.api.domain.message.response.HttpResponse;
import org.mule.service.http.netty.utils.client.TestHttp2StreamHandler;

public class TestHttp2Client
extends ExternalResource {
    private final String host;
    private final int port;
    private boolean connected;
    private Bootstrap bootstrap;
    private Channel connectionChannel;
    private EventLoopGroup clientWorkerGroup;
    private SslContext sslContext;

    public TestHttp2Client(String host, int port) {
        this.host = host;
        this.port = port;
        this.connected = false;
    }

    protected void before() throws Throwable {
        this.clientWorkerGroup = new NioEventLoopGroup();
        SslProvider provider = SslProvider.isAlpnSupported((SslProvider)SslProvider.OPENSSL) ? SslProvider.OPENSSL : SslProvider.JDK;
        this.sslContext = SslContextBuilder.forClient().sslProvider(provider).ciphers(null, (CipherSuiteFilter)IdentityCipherSuiteFilter.INSTANCE).trustManager(InsecureTrustManagerFactory.INSTANCE).applicationProtocolConfig(new ApplicationProtocolConfig(ApplicationProtocolConfig.Protocol.ALPN, ApplicationProtocolConfig.SelectorFailureBehavior.NO_ADVERTISE, ApplicationProtocolConfig.SelectedListenerFailureBehavior.ACCEPT, new String[]{"h2", "http/1.1"})).build();
        this.bootstrap = new Bootstrap();
        ((Bootstrap)((Bootstrap)((Bootstrap)this.bootstrap.group(this.clientWorkerGroup)).channel(NioSocketChannel.class)).option(ChannelOption.SO_KEEPALIVE, (Object)true)).remoteAddress(this.host, this.port);
    }

    protected void after() {
        try {
            if (this.connected) {
                this.connectionChannel.close().syncUninterruptibly();
            }
        }
        finally {
            this.clientWorkerGroup.shutdownGracefully();
        }
    }

    private void connectIfNeeded() {
        if (!this.connected) {
            this.connectionChannel = this.bootstrap.connect().syncUninterruptibly().channel();
            System.out.println("Connected to [" + this.host + ':' + this.port + ']');
            this.connected = true;
        }
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public HttpResponse sendGet(String path) {
        this.connectIfNeeded();
        TestHttp2StreamHandler streamHandler = new TestHttp2StreamHandler(this.connectionChannel);
        DefaultHttp2Headers headers = new DefaultHttp2Headers();
        headers.method((CharSequence)"GET");
        headers.path((CharSequence)path);
        headers.scheme((CharSequence)"https");
        DefaultHttp2HeadersFrame headersFrame = new DefaultHttp2HeadersFrame((Http2Headers)headers, true);
        ChannelFuture writeFuture = streamHandler.writeAndFlush((Http2Frame)headersFrame);
        System.out.println("Sent HTTP/2 GET request to '" + path + "'");
        return this.tryGetResponse(streamHandler, writeFuture);
    }

    public HttpResponse sendPost(String path, String content) {
        this.connectIfNeeded();
        TestHttp2StreamHandler streamHandler = new TestHttp2StreamHandler(this.connectionChannel);
        DefaultHttp2Headers headers = new DefaultHttp2Headers();
        headers.method((CharSequence)"POST");
        headers.path((CharSequence)path);
        headers.scheme((CharSequence)"https");
        DefaultHttp2HeadersFrame headersFrame = new DefaultHttp2HeadersFrame((Http2Headers)headers, false);
        streamHandler.write((Http2HeadersFrame)headersFrame);
        ByteBuf requestContent = streamHandler.allocateByteBuf();
        ByteBufUtil.writeUtf8((ByteBuf)requestContent, (CharSequence)content);
        DefaultHttp2DataFrame dataFrame = new DefaultHttp2DataFrame(requestContent, true);
        ChannelFuture writeFuture = streamHandler.writeAndFlush((Http2Frame)dataFrame);
        return this.tryGetResponse(streamHandler, writeFuture);
    }

    private HttpResponse tryGetResponse(TestHttp2StreamHandler streamHandler, ChannelFuture writeFuture) {
        if (!writeFuture.awaitUninterruptibly(10L, TimeUnit.SECONDS)) {
            throw new IllegalStateException("Timed out waiting to write");
        }
        if (!writeFuture.isSuccess()) {
            throw new RuntimeException(writeFuture.cause());
        }
        if (!streamHandler.awaitResponseSuccessfullyCompleted()) {
            System.err.println("Did not get HTTP/2 response in expected time.");
            return null;
        }
        HttpResponse response = streamHandler.getResponse();
        System.out.println("Finished HTTP/2 request. Got response: " + response);
        return response;
    }
}

