/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.http.netty.utils.client;

import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.handler.codec.http2.Http2Frame;
import io.netty.handler.codec.http2.Http2HeadersFrame;
import io.netty.handler.codec.http2.Http2StreamChannel;
import io.netty.handler.codec.http2.Http2StreamChannelBootstrap;
import org.mule.runtime.http.api.domain.message.response.HttpResponse;
import org.mule.service.http.netty.utils.client.TestHttp2ClientResponseHandler;

public class TestHttp2StreamHandler {
    private final Http2StreamChannel streamChannel;
    private final TestHttp2ClientResponseHandler streamFrameResponseHandler = new TestHttp2ClientResponseHandler();

    public TestHttp2StreamHandler(Channel connectionChannel) {
        Http2StreamChannelBootstrap streamChannelBootstrap = new Http2StreamChannelBootstrap(connectionChannel);
        this.streamChannel = (Http2StreamChannel)streamChannelBootstrap.open().syncUninterruptibly().getNow();
        this.streamChannel.pipeline().addLast(new ChannelHandler[]{this.streamFrameResponseHandler});
    }

    public ChannelFuture writeAndFlush(Http2Frame http2Frame) {
        return this.streamChannel.writeAndFlush((Object)http2Frame);
    }

    public boolean awaitResponseSuccessfullyCompleted() {
        return this.streamFrameResponseHandler.awaitResponseSuccessfullyCompleted();
    }

    public HttpResponse getResponse() {
        return this.streamFrameResponseHandler.getResponse();
    }

    public ChannelFuture write(Http2HeadersFrame headersFrame) {
        return this.streamChannel.write((Object)headersFrame);
    }

    public ByteBuf allocateByteBuf() {
        return this.streamChannel.alloc().buffer();
    }
}

