/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.http.netty.impl.util;

import io.netty.util.internal.logging.AbstractInternalLogger;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.message.FormattedMessageFactory;
import org.junit.rules.ExternalResource;

public class NettyLoggerRule
extends ExternalResource {
    private InternalLoggerFactory defaultFactory;
    private TestLoggerFactory testFactory;

    protected void before() throws Throwable {
        this.defaultFactory = InternalLoggerFactory.getDefaultFactory();
        this.testFactory = new TestLoggerFactory(this.defaultFactory);
        InternalLoggerFactory.setDefaultFactory((InternalLoggerFactory)this.testFactory);
    }

    public List<String> getDebugLogs(String loggerName) {
        return this.testFactory.getLogger(loggerName).getDebugLogs();
    }

    protected void after() {
        InternalLoggerFactory.setDefaultFactory((InternalLoggerFactory)this.defaultFactory);
    }

    private static class TestLoggerFactory
    extends InternalLoggerFactory {
        private final Map<String, TestInternalLogger> loggersByName = new HashMap<String, TestInternalLogger>();
        private final InternalLoggerFactory defaultFactory;

        public TestLoggerFactory(InternalLoggerFactory defaultFactory) {
            this.defaultFactory = defaultFactory;
        }

        protected InternalLogger newInstance(String name) {
            return (InternalLogger)this.loggersByName.computeIfAbsent(name, key -> {
                TestLoggerFactory.setDefaultFactory((InternalLoggerFactory)this.defaultFactory);
                try {
                    InternalLogger actualNettyLogger = TestLoggerFactory.getInstance((String)key);
                    TestInternalLogger testInternalLogger = new TestInternalLogger((String)key, actualNettyLogger);
                    return testInternalLogger;
                }
                finally {
                    TestLoggerFactory.setDefaultFactory((InternalLoggerFactory)this);
                }
            });
        }

        public TestInternalLogger getLogger(String name) {
            return this.loggersByName.get(name);
        }
    }

    public static class TestInternalLogger
    extends InternalLoggerDelegate {
        private final FormattedMessageFactory messageFactory = new FormattedMessageFactory();
        private final List<String> debugLogs = new ArrayList<String>();

        protected TestInternalLogger(String name, InternalLogger delegate) {
            super(name, delegate);
        }

        @Override
        public boolean isDebugEnabled() {
            return true;
        }

        @Override
        public void debug(String msg) {
            this.debugLogs.add(this.messageFactory.newMessage(msg).getFormattedMessage());
            super.debug(msg);
        }

        @Override
        public void debug(String fmt, Object arg1) {
            this.debugLogs.add(this.messageFactory.newMessage(fmt, arg1).getFormattedMessage());
            super.debug(fmt, arg1);
        }

        @Override
        public void debug(String fmt, Object arg1, Object arg2) {
            this.debugLogs.add(this.messageFactory.newMessage(fmt, arg1, arg2).getFormattedMessage());
            super.debug(fmt, arg1, arg2);
        }

        @Override
        public void debug(String fmt, Object ... args) {
            this.debugLogs.add(this.messageFactory.newMessage(fmt, args).getFormattedMessage());
            super.debug(fmt, args);
        }

        @Override
        public void debug(String msg, Throwable throwable) {
            this.debugLogs.add(this.messageFactory.newMessage(msg, (Object)throwable).getFormattedMessage());
            super.debug(msg, throwable);
        }

        public List<String> getDebugLogs() {
            return Collections.unmodifiableList(this.debugLogs);
        }
    }

    public static class InternalLoggerDelegate
    extends AbstractInternalLogger {
        private final InternalLogger delegate;

        protected InternalLoggerDelegate(String name, InternalLogger delegate) {
            super(name);
            this.delegate = delegate;
        }

        public boolean isDebugEnabled() {
            return this.delegate.isDebugEnabled();
        }

        public void debug(String msg) {
            this.delegate.debug(msg);
        }

        public void debug(String fmt, Object arg1) {
            this.delegate.debug(fmt, arg1);
        }

        public void debug(String fmt, Object arg1, Object arg2) {
            this.delegate.debug(fmt, arg1, arg2);
        }

        public void debug(String fmt, Object ... args) {
            this.delegate.debug(fmt, args);
        }

        public void debug(String msg, Throwable throwable) {
            this.delegate.debug(msg, throwable);
        }

        public boolean isTraceEnabled() {
            return this.delegate.isTraceEnabled();
        }

        public void trace(String s) {
            this.delegate.trace(s);
        }

        public void trace(String s, Object o) {
            this.delegate.trace(s, o);
        }

        public void trace(String s, Object o, Object o1) {
            this.delegate.trace(s, o, o1);
        }

        public void trace(String s, Object ... objects) {
            this.delegate.trace(s, objects);
        }

        public void trace(String s, Throwable throwable) {
            this.delegate.trace(s, throwable);
        }

        public boolean isInfoEnabled() {
            return this.delegate.isInfoEnabled();
        }

        public void info(String s) {
            this.delegate.info(s);
        }

        public void info(String s, Object o) {
            this.delegate.info(s, o);
        }

        public void info(String s, Object o, Object o1) {
            this.delegate.info(s, o, o1);
        }

        public void info(String s, Object ... objects) {
            this.delegate.info(s, objects);
        }

        public void info(String s, Throwable throwable) {
            this.delegate.info(s, throwable);
        }

        public boolean isWarnEnabled() {
            return this.delegate.isWarnEnabled();
        }

        public void warn(String s) {
            this.delegate.warn(s);
        }

        public void warn(String s, Object o) {
            this.delegate.warn(s, o);
        }

        public void warn(String s, Object ... objects) {
            this.delegate.warn(s, objects);
        }

        public void warn(String s, Object o, Object o1) {
            this.delegate.warn(s, o, o1);
        }

        public void warn(String s, Throwable throwable) {
            this.delegate.warn(s, throwable);
        }

        public boolean isErrorEnabled() {
            return this.delegate.isErrorEnabled();
        }

        public void error(String s) {
            this.delegate.error(s);
        }

        public void error(String s, Object o) {
            this.delegate.error(s, o);
        }

        public void error(String s, Object o, Object o1) {
            this.delegate.error(s, o, o1);
        }

        public void error(String s, Object ... objects) {
            this.delegate.error(s, objects);
        }

        public void error(String s, Throwable throwable) {
            this.delegate.error(s, throwable);
        }
    }
}

