/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.http.netty.impl.server;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufInputStream;
import io.netty.buffer.ByteBufUtil;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.HttpObject;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.LastHttpContent;
import io.netty.handler.ssl.SslHandler;
import io.netty.util.ReferenceCountUtil;
import io.netty.util.concurrent.GenericFutureListener;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.URISyntaxException;
import org.mule.runtime.http.api.domain.request.HttpRequestContext;
import org.mule.runtime.http.api.server.RequestHandler;
import org.mule.runtime.http.api.server.async.HttpResponseReadyCallback;
import org.mule.service.http.netty.impl.message.NettyHttpRequestAdapter;
import org.mule.service.http.netty.impl.server.NettyHttp1RequestReadyCallback;
import org.mule.service.http.netty.impl.server.NettyHttpRequestContext;
import org.mule.service.http.netty.impl.server.util.DefaultServerAddress;
import org.mule.service.http.netty.impl.server.util.HttpListenerRegistry;
import org.mule.service.http.netty.impl.streaming.BlockingBidirectionalStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ForwardingToListenerHandler
extends SimpleChannelInboundHandler<HttpObject> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ForwardingToListenerHandler.class);
    private final HttpListenerRegistry httpListenerRegistry;
    private final SslHandler sslHandler;
    private OutputStream currentRequestContentSink;

    public ForwardingToListenerHandler(HttpListenerRegistry httpListenerRegistry, SslHandler sslHandler) {
        this.httpListenerRegistry = httpListenerRegistry;
        this.sslHandler = sslHandler;
        this.currentRequestContentSink = null;
    }

    protected void channelRead0(ChannelHandlerContext ctx, HttpObject httpObject) throws Exception {
        if (httpObject instanceof HttpRequest) {
            HttpRequest httpRequest = (HttpRequest)httpObject;
            InetSocketAddress socketAddress = (InetSocketAddress)ctx.channel().localAddress();
            DefaultServerAddress serverAddress = new DefaultServerAddress(socketAddress.getAddress(), socketAddress.getPort());
            org.mule.runtime.http.api.domain.message.request.HttpRequest muleRequest = this.nettyToMuleRequest(httpRequest, socketAddress);
            try {
                RequestHandler requestHandler = this.getRequestHandler(httpRequest, serverAddress, muleRequest);
                requestHandler.handleRequest((HttpRequestContext)new NettyHttpRequestContext(muleRequest, ctx, this.sslHandler), (HttpResponseReadyCallback)new NettyHttp1RequestReadyCallback(ctx, muleRequest));
            }
            catch (Exception exception) {
                if (exception instanceof RuntimeException && exception.getCause() instanceof URISyntaxException) {
                    ForwardingToListenerHandler.handleMalformedUri(ctx, httpObject, (URISyntaxException)exception.getCause());
                }
                throw exception;
            }
        }
        if (httpObject instanceof HttpContent && !(httpObject instanceof FullHttpRequest)) {
            HttpContent content = (HttpContent)httpObject;
            this.handleContent(content);
        }
    }

    private void handleContent(HttpContent content) throws IOException {
        byte[] frameData = ByteBufUtil.getBytes((ByteBuf)content.content());
        try {
            this.currentRequestContentSink.write(frameData, 0, frameData.length);
        }
        catch (IOException exception) {
            if ("Trying to write in a closed buffer".equals(exception.getMessage())) {
                LOGGER.info("Nobody is reading the payload, so we are ignoring part of the content...");
            }
            throw exception;
        }
        if (content instanceof LastHttpContent) {
            this.currentRequestContentSink.close();
            this.currentRequestContentSink = null;
        }
    }

    private RequestHandler getRequestHandler(HttpRequest nettyRequest, DefaultServerAddress serverAddress, org.mule.runtime.http.api.domain.message.request.HttpRequest muleRequest) {
        RequestHandler requestHandler;
        if (nettyRequest.decoderResult().isFailure() && (requestHandler = this.httpListenerRegistry.getErrorHandler(nettyRequest.decoderResult().cause())) != null) {
            return requestHandler;
        }
        return this.httpListenerRegistry.getRequestHandler(serverAddress, muleRequest);
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        LOGGER.error("Exception caught", cause);
        ctx.close();
    }

    private org.mule.runtime.http.api.domain.message.request.HttpRequest nettyToMuleRequest(HttpRequest httpRequest, InetSocketAddress localAddress) {
        return new NettyHttpRequestAdapter(httpRequest, localAddress, this.createContent(httpRequest));
    }

    private InputStream createContent(HttpRequest httpRequest) {
        if (httpRequest instanceof FullHttpRequest) {
            FullHttpRequest fullHttpRequest = (FullHttpRequest)httpRequest;
            return new ByteBufInputStream(fullHttpRequest.content().retainedDuplicate());
        }
        BlockingBidirectionalStream blockingBuffer = new BlockingBidirectionalStream();
        this.currentRequestContentSink = blockingBuffer.getOutputStream();
        return blockingBuffer.getInputStream();
    }

    SslHandler getSslHandler() {
        return this.sslHandler;
    }

    private static void handleMalformedUri(ChannelHandlerContext ctx, HttpObject httpObject, URISyntaxException exception) {
        HttpRequest httpRequest = (HttpRequest)httpObject;
        ByteBuf responseMsg = Unpooled.buffer();
        ByteBufUtil.writeUtf8((ByteBuf)responseMsg, (CharSequence)String.format("HTTP request parsing failed with error: \"%s\"", exception.getMessage()));
        DefaultFullHttpResponse rejection = new DefaultFullHttpResponse(httpRequest.protocolVersion(), HttpResponseStatus.BAD_REQUEST, responseMsg);
        ReferenceCountUtil.release((Object)httpObject);
        ctx.writeAndFlush((Object)rejection).addListener((GenericFutureListener)ChannelFutureListener.CLOSE_ON_FAILURE);
    }
}

