/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.http.impl.service.client;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;
import org.mule.service.http.impl.service.util.ThreadContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;

public class NonBlockingStreamWriter
implements Runnable {
    private static final boolean KILL_SWITCH = Boolean.getBoolean("mule.http.client.responseStreaming.nonBlockingWriter");
    private static final Logger LOGGER = LoggerFactory.getLogger(NonBlockingStreamWriter.class);
    private static final int DEFAULT_TIME_TO_SLEEP_WHEN_COULD_NOT_WRITE_MILLIS = 100;
    private final AtomicBoolean isStopped = new AtomicBoolean(false);
    private final BlockingQueue<InternalWriteTask> tasks = new LinkedBlockingQueue<InternalWriteTask>();
    private final int timeToSleepWhenCouldNotWriteMillis;
    private final boolean isEnabled;

    public NonBlockingStreamWriter(int timeToSleepWhenCouldNotWriteMillis, boolean isEnabled) {
        this.timeToSleepWhenCouldNotWriteMillis = timeToSleepWhenCouldNotWriteMillis;
        this.isEnabled = isEnabled;
    }

    public NonBlockingStreamWriter() {
        this(100, KILL_SWITCH);
    }

    public boolean isEnabled() {
        return this.isEnabled;
    }

    public CompletableFuture<Void> addDataToWrite(OutputStream destinationStream, byte[] dataToWrite, Supplier<Integer> availableSpace) {
        InternalWriteTask internalWriteTask = new InternalWriteTask(destinationStream, dataToWrite, availableSpace);
        boolean couldCompleteSync = internalWriteTask.execute();
        if (!couldCompleteSync) {
            this.tasks.add(internalWriteTask);
        }
        return internalWriteTask.getFuture();
    }

    @Override
    public void run() {
        while (!this.isStopped.get()) {
            try {
                boolean couldWriteSomething = this.writeWhateverPossible();
                if (couldWriteSomething || this.isStopped.get()) continue;
                LOGGER.trace("Giving some time to the other threads to consume from pipes...");
                Thread.sleep(this.timeToSleepWhenCouldNotWriteMillis);
            }
            catch (InterruptedException e) {
                if (this.isStopped.get()) continue;
                LOGGER.warn("Non blocking writer thread was interrupted before it was stopped. It will resume the execution", (Throwable)e);
            }
        }
    }

    public void stop() {
        this.isStopped.set(true);
    }

    private boolean writeWhateverPossible() throws InterruptedException {
        ArrayList<InternalWriteTask> tasksWithPendingData = new ArrayList<InternalWriteTask>(this.tasks.size());
        boolean couldWriteSomething = false;
        InternalWriteTask task = this.tasks.poll(100L, TimeUnit.MILLISECONDS);
        while (task != null) {
            int remainingBeforeExecute = task.remaining();
            boolean couldComplete = task.execute();
            int remainingAfterExecute = task.remaining();
            if (!couldComplete) {
                tasksWithPendingData.add(task);
            }
            if (remainingAfterExecute < remainingBeforeExecute) {
                couldWriteSomething = true;
            }
            task = this.tasks.poll(100L, TimeUnit.MILLISECONDS);
        }
        this.tasks.addAll(tasksWithPendingData);
        return couldWriteSomething;
    }

    private static final class InternalWriteTask {
        private static final AtomicInteger idGenerator = new AtomicInteger(0);
        private final OutputStream destinationStream;
        private final byte[] dataToWrite;
        private final int totalBytesToWrite;
        private final Supplier<Integer> availableSpace;
        private final CompletableFuture<Void> toCompleteWhenAllDataIsWritten;
        private final int id = idGenerator.getAndIncrement();
        private final Map<String, String> callerMDC;
        private final ClassLoader callerTCCL;
        private int alreadyWritten;

        public InternalWriteTask(OutputStream destinationStream, byte[] dataToWrite, Supplier<Integer> availableSpace) {
            this.destinationStream = destinationStream;
            this.availableSpace = availableSpace;
            this.toCompleteWhenAllDataIsWritten = new CompletableFuture();
            this.totalBytesToWrite = dataToWrite.length;
            this.dataToWrite = dataToWrite;
            this.alreadyWritten = 0;
            this.callerMDC = MDC.getCopyOfContextMap();
            this.callerTCCL = Thread.currentThread().getContextClassLoader();
        }

        public int remaining() {
            return this.totalBytesToWrite - this.alreadyWritten;
        }

        public boolean execute() {
            ThreadContext threadContext = new ThreadContext(this.callerTCCL, this.callerMDC);
            try {
                int remainingBytes = this.totalBytesToWrite - this.alreadyWritten;
                int bytesToWriteInThisExecution = Math.min(this.availableSpace.get(), remainingBytes);
                while (bytesToWriteInThisExecution > 0) {
                    try {
                        this.destinationStream.write(this.dataToWrite, this.alreadyWritten, bytesToWriteInThisExecution);
                    }
                    catch (Exception e) {
                        this.toCompleteWhenAllDataIsWritten.completeExceptionally(e);
                        LOGGER.trace("Error on write (id: {})", (Object)this.id, (Object)e);
                        boolean bl = true;
                        threadContext.close();
                        return bl;
                    }
                    this.alreadyWritten += bytesToWriteInThisExecution;
                    remainingBytes = this.totalBytesToWrite - this.alreadyWritten;
                    bytesToWriteInThisExecution = Math.min(this.availableSpace.get(), remainingBytes);
                }
                if (this.alreadyWritten == this.totalBytesToWrite) {
                    LOGGER.trace("Fully written (id: {})", (Object)this.id);
                    this.toCompleteWhenAllDataIsWritten.complete(null);
                    boolean bl = true;
                    return bl;
                }
                if (bytesToWriteInThisExecution == -1) {
                    LOGGER.trace("Destination stream closed (id: {})", (Object)this.id);
                    this.toCompleteWhenAllDataIsWritten.completeExceptionally(new IOException("Pipe closed"));
                    boolean bl = true;
                    return bl;
                }
                LOGGER.trace("Written bytes: {}/{} (id: {})", new Object[]{this.alreadyWritten, this.totalBytesToWrite, this.id});
                boolean bl = false;
                return bl;
            }
            finally {
                try {
                    threadContext.close();
                }
                catch (Throwable throwable) {
                    Throwable throwable2;
                    throwable2.addSuppressed(throwable);
                }
            }
        }

        public CompletableFuture<Void> getFuture() {
            return this.toCompleteWhenAllDataIsWritten;
        }
    }
}

