/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.http.impl.functional.client;

import com.ning.http.client.AsyncHandler;
import com.ning.http.client.HttpResponseBodyPart;
import com.ning.http.client.HttpResponseHeaders;
import com.ning.http.client.HttpResponseStatus;
import com.ning.http.client.Request;
import com.ning.http.client.filter.FilterContext;
import com.ning.http.client.filter.FilterException;
import io.qameta.allure.Issue;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.mule.service.http.impl.service.client.CustomTimeoutThrottleRequestFilter;

@Issue(value="W-14686211")
public class CustomTimeoutThrottleRequestFilterTestCase {
    @Test
    public void aFilterContextIsAvailableAfterAnOnThrowableCallWhenMaxConnectionsIsOne() throws Exception {
        TestCustomTimeoutThrottleRequestFilter testCustomTimeoutThrottleRequestFilter = new TestCustomTimeoutThrottleRequestFilter(1);
        FilterContext context = testCustomTimeoutThrottleRequestFilter.filter(CustomTimeoutThrottleRequestFilterTestCase.getFilterContext());
        context.getAsyncHandler().onThrowable((Throwable)Mockito.mock(Throwable.class));
    }

    private static FilterContext getFilterContext() {
        Request request = (Request)Mockito.mock(Request.class);
        FilterContext filterContext = (FilterContext)Mockito.mock(FilterContext.class);
        Mockito.when((Object)filterContext.getRequest()).thenReturn((Object)request);
        Mockito.when((Object)request.getRequestTimeout()).thenReturn((Object)100);
        return filterContext;
    }

    private static class TestCustomTimeoutThrottleRequestFilter
    extends CustomTimeoutThrottleRequestFilter {
        public TestCustomTimeoutThrottleRequestFilter(int maxConnections) {
            super(maxConnections);
        }

        protected AsyncHandler resolveAsyncHandler(FilterContext ctx) {
            return new AsyncHandler(){

                public void onThrowable(Throwable throwable) {
                    try {
                        this.filter(CustomTimeoutThrottleRequestFilterTestCase.getFilterContext());
                    }
                    catch (FilterException e) {
                        Assert.fail((String)e.getMessage());
                    }
                }

                public AsyncHandler.STATE onBodyPartReceived(HttpResponseBodyPart httpResponseBodyPart) throws Exception {
                    return null;
                }

                public AsyncHandler.STATE onStatusReceived(HttpResponseStatus httpResponseStatus) throws Exception {
                    return null;
                }

                public AsyncHandler.STATE onHeadersReceived(HttpResponseHeaders httpResponseHeaders) throws Exception {
                    return null;
                }

                public Object onCompleted() throws Exception {
                    return null;
                }
            };
        }
    }
}

