/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.http.impl.functional.server;

import org.junit.After;
import org.junit.Rule;
import org.mule.runtime.http.api.server.HttpServer;
import org.mule.runtime.http.api.server.HttpServerConfiguration;
import org.mule.service.http.impl.functional.AbstractHttpServiceTestCase;
import org.mule.tck.junit4.rule.DynamicPort;

public abstract class AbstractHttpServerTestCase
extends AbstractHttpServiceTestCase {
    @Rule
    public DynamicPort port = new DynamicPort("port");
    protected HttpServer server;

    public AbstractHttpServerTestCase(String serviceToLoad) {
        super(serviceToLoad);
    }

    protected void setUpServer() throws Exception {
        this.server = this.service.getServerFactory().create(this.configureServer(new HttpServerConfiguration.Builder().setHost("localhost").setPort(this.port.getNumber()).setName(this.getServerName())).build());
        this.server.start();
    }

    protected abstract String getServerName();

    protected HttpServerConfiguration.Builder configureServer(HttpServerConfiguration.Builder builder) {
        return builder;
    }

    @After
    public void tearDown() {
        if (this.server != null) {
            this.server.stop();
            this.server.dispose();
        }
    }
}

