/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.http.impl.service;

import java.util.Map;
import org.glassfish.grizzly.Buffer;
import org.glassfish.grizzly.Connection;
import org.glassfish.grizzly.http.HttpProbe;
import org.mule.service.http.impl.service.util.ThreadContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpMessageLogger
extends HttpProbe.Adapter {
    private final Logger logger;
    private final LoggerType loggerType;
    private final ClassLoader classLoader;
    public static final String MDC_ATTRIBUTE_KEY = "mdc";

    HttpMessageLogger(LoggerType loggerType, ClassLoader classLoader, Logger logger) {
        this.loggerType = loggerType;
        this.classLoader = classLoader;
        this.logger = logger;
    }

    public HttpMessageLogger(LoggerType loggerType, String identifier, ClassLoader classLoader) {
        this(loggerType, classLoader, LoggerFactory.getLogger((String)(HttpMessageLogger.class.getName() + "." + identifier)));
    }

    public void onDataReceivedEvent(Connection connection, Buffer buffer) {
        this.logBuffer(connection, buffer);
    }

    public void onDataSentEvent(Connection connection, Buffer buffer) {
        this.logBuffer(connection, buffer);
    }

    private void logBuffer(Connection connection, Buffer buffer) {
        try (ThreadContext threadContext = this.createContext(connection);){
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("{}\n{}", (Object)this.loggerType.name(), (Object)buffer.toStringContent());
            }
        }
    }

    private ThreadContext createContext(Connection connection) {
        return new ThreadContext(this.classLoader, (Map)connection.getAttributes().getAttribute(MDC_ATTRIBUTE_KEY));
    }

    public static enum LoggerType {
        LISTENER,
        REQUESTER;

    }
}

