/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.http.impl.service.client.async;

import com.ning.http.client.AsyncCompletionHandler;
import com.ning.http.client.Response;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeoutException;
import org.mule.runtime.http.api.domain.message.response.HttpResponse;
import org.mule.service.http.impl.service.client.HttpResponseCreator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;

public class ResponseAsyncHandler
extends AsyncCompletionHandler<Response> {
    private static final Logger logger = LoggerFactory.getLogger(ResponseAsyncHandler.class);
    private final CompletableFuture<HttpResponse> future;
    private final HttpResponseCreator httpResponseCreator = new HttpResponseCreator();
    private final Map<String, String> mdc;

    public ResponseAsyncHandler(CompletableFuture<HttpResponse> future) {
        this.future = future;
        this.mdc = MDC.getCopyOfContextMap();
    }

    public Response onCompleted(Response response) throws Exception {
        try {
            MDC.setContextMap(this.mdc);
            try {
                this.future.complete(this.httpResponseCreator.create(response, response.getResponseBodyAsStream()));
            }
            catch (Throwable t) {
                this.onThrowable(t);
            }
            Response response2 = null;
            return response2;
        }
        finally {
            MDC.clear();
        }
    }

    public void onThrowable(Throwable t) {
        try {
            MDC.setContextMap(this.mdc);
            logger.debug("Error handling HTTP response.", t);
            Exception exception = t instanceof TimeoutException ? (TimeoutException)t : (t instanceof IOException ? (IOException)t : new IOException(t.getMessage(), t));
            this.future.completeExceptionally(exception);
        }
        finally {
            MDC.clear();
        }
    }
}

