/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.http.impl.service.util;

import io.qameta.allure.Feature;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.mule.runtime.http.api.HttpConstants;
import org.mule.runtime.http.api.domain.message.request.HttpRequest;
import org.mule.runtime.http.api.server.MethodRequestMatcher;
import org.mule.runtime.http.api.server.PathAndMethodRequestMatcher;
import org.mule.runtime.http.api.utils.RequestMatcherRegistry;
import org.mule.service.http.impl.service.util.DefaultRequestMatcherRegistryBuilder;
import org.mule.tck.junit4.AbstractMuleTestCase;

@Feature(value="HTTP Service")
public class DefaultRequestMatcherRegistryTestCase
extends AbstractMuleTestCase {
    private static final Object METHOD_MISMATCH = new Object();
    private static final Object NOT_FOUND = new Object();
    private static final Object DISABLED = new Object();
    private static final Object SECOND_LEVEL_CATCH_ALL = new Object();
    private static final Object SECOND_LEVEL_SPECIFIC = new Object();
    private static final Object FIRST_LEVEL_SPECIFIC = new Object();

    @Test
    public void findByRequest() {
        RequestMatcherRegistry registry = this.buildRegistry(this.getFullBuilder());
        this.validateRequestMatch(registry, "/path/somewhere", SECOND_LEVEL_CATCH_ALL);
        this.validateRequestMatch(registry, "/path/here", SECOND_LEVEL_SPECIFIC);
        this.validateRequestMatch(registry, "/here", DISABLED);
        this.validateRequestMatch(registry, "/nope", NOT_FOUND);
        this.validateRequestMatch(registry, "/path/somewhere", Matchers.sameInstance((Object)METHOD_MISMATCH), HttpConstants.Method.POST);
    }

    @Test
    public void findsByMethodAndPath() {
        RequestMatcherRegistry registry = this.buildRegistry(this.getFullBuilder());
        this.validateMethodAndPathMatch(registry, "/path/somewhere", SECOND_LEVEL_CATCH_ALL);
        this.validateMethodAndPathMatch(registry, "/path/here", SECOND_LEVEL_SPECIFIC);
        this.validateMethodAndPathMatch(registry, "/here", DISABLED);
        this.validateMethodAndPathMatch(registry, "/nope", NOT_FOUND);
        this.validateMethodAndPathMatch(registry, "/path/somewhere", Matchers.sameInstance((Object)METHOD_MISMATCH), HttpConstants.Method.POST);
    }

    @Test
    public void allNullIfDefault() {
        RequestMatcherRegistry registry = this.buildRegistry((RequestMatcherRegistry.RequestMatcherRegistryBuilder)new DefaultRequestMatcherRegistryBuilder());
        this.validateMethodAndPathMatch(registry, "/path/somewhere", SECOND_LEVEL_CATCH_ALL);
        this.validateMethodAndPathMatch(registry, "/path/here", SECOND_LEVEL_SPECIFIC);
        this.validateMethodAndPathMatch(registry, "/here", Matchers.nullValue(), HttpConstants.Method.GET);
        this.validateMethodAndPathMatch(registry, "/nope", Matchers.nullValue(), HttpConstants.Method.GET);
        this.validateMethodAndPathMatch(registry, "/path/somewhere", Matchers.nullValue(), HttpConstants.Method.POST);
    }

    private RequestMatcherRegistry buildRegistry(RequestMatcherRegistry.RequestMatcherRegistryBuilder builder) {
        RequestMatcherRegistry registry = builder.build();
        registry.add(PathAndMethodRequestMatcher.builder().methodRequestMatcher(MethodRequestMatcher.builder().add(HttpConstants.Method.GET).build()).path("/path/*").build(), SECOND_LEVEL_CATCH_ALL);
        registry.add(PathAndMethodRequestMatcher.builder().path("/path/here").build(), SECOND_LEVEL_SPECIFIC);
        registry.add(PathAndMethodRequestMatcher.builder().path("/here").build(), FIRST_LEVEL_SPECIFIC).disable();
        return registry;
    }

    private RequestMatcherRegistry.RequestMatcherRegistryBuilder<Object> getFullBuilder() {
        return new DefaultRequestMatcherRegistryBuilder().onMethodMismatch(() -> METHOD_MISMATCH).onNotFound(() -> NOT_FOUND).onDisabled(() -> DISABLED);
    }

    private void validateRequestMatch(RequestMatcherRegistry registry, String path, Object expectedItem) {
        this.validateRequestMatch(registry, path, Matchers.sameInstance((Object)expectedItem), HttpConstants.Method.GET);
    }

    private void validateRequestMatch(RequestMatcherRegistry registry, String path, Matcher matcher, HttpConstants.Method method) {
        Assert.assertThat((Object)registry.find(HttpRequest.builder().uri(String.format("http://localhost:8081%s", path)).method(method).build()), (Matcher)Matchers.is((Matcher)matcher));
    }

    private void validateMethodAndPathMatch(RequestMatcherRegistry registry, String path, Object expectedItem) {
        this.validateMethodAndPathMatch(registry, path, Matchers.sameInstance((Object)expectedItem), HttpConstants.Method.GET);
    }

    private void validateMethodAndPathMatch(RequestMatcherRegistry registry, String path, Matcher matcher, HttpConstants.Method method) {
        Assert.assertThat((Object)registry.find(method.name(), path), (Matcher)Matchers.is((Matcher)matcher));
    }
}

