/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.http.impl.service;

import io.qameta.allure.Issue;
import java.util.Map;
import org.apache.commons.collections.map.SingletonMap;
import org.glassfish.grizzly.Buffer;
import org.glassfish.grizzly.Connection;
import org.glassfish.grizzly.attributes.AttributeHolder;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.mockito.junit.MockitoJUnitRunner;
import org.mule.runtime.api.util.Reference;
import org.mule.service.http.impl.service.HttpMessageLogger;
import org.mule.tck.size.SmallTest;
import org.slf4j.Logger;
import org.slf4j.MDC;

@RunWith(value=MockitoJUnitRunner.class)
@SmallTest
@Issue(value="MULE-19243")
public class HttpMessageLoggerTestCase {
    @Mock
    private ClassLoader classLoader;
    @Mock
    private Logger logger;
    @Mock
    private Buffer buffer;
    @Mock
    private Connection connection;
    @Mock
    private AttributeHolder connectionAttributeHolder;
    private Reference<ClassLoader> onLogClassLoader;
    private Reference<Map<String, String>> onLogMDC;
    private HttpMessageLogger httpMessageLogger;

    @Before
    public void setup() {
        MockitoAnnotations.initMocks(HttpMessageLoggerTestCase.class);
        Mockito.when((Object)this.connectionAttributeHolder.getAttribute((String)ArgumentMatchers.eq((Object)"mdc"))).thenReturn((Object)new SingletonMap((Object)"mdcKey", (Object)"mdcValue"));
        Mockito.when((Object)this.connection.getAttributes()).thenReturn((Object)this.connectionAttributeHolder);
        ((Logger)Mockito.doAnswer(invocation -> {
            this.onLogClassLoader.set((Object)Thread.currentThread().getContextClassLoader());
            this.onLogMDC.set((Object)MDC.getCopyOfContextMap());
            return null;
        }).when((Object)this.logger)).debug(ArgumentMatchers.anyString(), ArgumentMatchers.any(), ArgumentMatchers.any());
        Mockito.when((Object)this.logger.isDebugEnabled()).thenReturn((Object)true);
        this.onLogClassLoader = new Reference();
        this.onLogMDC = new Reference();
        this.httpMessageLogger = new HttpMessageLogger(HttpMessageLogger.LoggerType.REQUESTER, this.classLoader, this.logger);
    }

    @Test
    public void mdcIsPreservedOnDataReceived() {
        this.httpMessageLogger.onDataReceivedEvent(this.connection, this.buffer);
        Assert.assertThat(((Map)this.onLogMDC.get()).get("mdcKey"), (Matcher)Matchers.is((Object)"mdcValue"));
    }

    @Test
    public void classLoaderIsPreservedOnDataReceived() {
        this.httpMessageLogger.onDataReceivedEvent(this.connection, this.buffer);
        Assert.assertThat((Object)this.onLogClassLoader.get(), (Matcher)Matchers.is((Object)this.classLoader));
    }

    @Test
    public void mdcIsPreservedOnDataSent() {
        this.httpMessageLogger.onDataSentEvent(this.connection, this.buffer);
        Assert.assertThat(((Map)this.onLogMDC.get()).get("mdcKey"), (Matcher)Matchers.is((Object)"mdcValue"));
    }

    @Test
    public void classLoaderIsPreservedOnDataSent() {
        this.httpMessageLogger.onDataSentEvent(this.connection, this.buffer);
        Assert.assertThat((Object)this.onLogClassLoader.get(), (Matcher)Matchers.is((Object)this.classLoader));
    }
}

