/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.http.impl.service.client.async;

import com.ning.http.client.AsyncHandler;
import com.ning.http.client.HttpResponseBodyPart;
import com.ning.http.client.HttpResponseHeaders;
import com.ning.http.client.HttpResponseStatus;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.mule.runtime.api.util.Reference;
import org.mule.runtime.core.api.util.ClassUtils;
import org.mule.service.http.impl.service.client.async.PreservingClassLoaderAsyncHandler;
import org.mule.tck.junit4.AbstractMuleTestCase;

@RunWith(value=MockitoJUnitRunner.class)
public class PreservingClassLoaderAsyncHandlerTestCase
extends AbstractMuleTestCase {
    @Mock
    private AsyncHandler<Integer> delegate;
    @Mock
    private ClassLoader mockClassLoader;
    private PreservingClassLoaderAsyncHandler<Integer> asyncHandler;
    private ClassLoader classLoaderOnCreation;

    @Before
    public void setup() {
        this.classLoaderOnCreation = Thread.currentThread().getContextClassLoader();
        this.asyncHandler = new PreservingClassLoaderAsyncHandler(this.delegate);
    }

    @Test
    public void creationClassLoaderIsPreservedOnCompleted() throws Exception {
        Reference classLoaderOnCompleted = new Reference();
        Mockito.when((Object)this.delegate.onCompleted()).then(invocation -> {
            classLoaderOnCompleted.set((Object)Thread.currentThread().getContextClassLoader());
            return Mockito.doCallRealMethod();
        });
        ClassUtils.withContextClassLoader((ClassLoader)this.mockClassLoader, () -> this.asyncHandler.onCompleted());
        Assert.assertThat((Object)classLoaderOnCompleted.get(), (Matcher)Matchers.is((Object)this.classLoaderOnCreation));
    }

    @Test
    public void creationClassLoaderIsPreservedOnThrowable() {
        Reference classLoaderOnThrowable = new Reference();
        ((AsyncHandler)Mockito.doAnswer(invocation -> {
            classLoaderOnThrowable.set((Object)Thread.currentThread().getContextClassLoader());
            return Mockito.doCallRealMethod();
        }).when(this.delegate)).onThrowable((Throwable)org.mockito.Matchers.any(Throwable.class));
        ClassUtils.withContextClassLoader((ClassLoader)this.mockClassLoader, () -> this.asyncHandler.onThrowable(new Throwable()));
        Assert.assertThat((Object)classLoaderOnThrowable.get(), (Matcher)Matchers.is((Object)this.classLoaderOnCreation));
    }

    @Test
    public void creationClassLoaderIsPreservedOnBodyPartReceived() throws Exception {
        Reference classLoaderOnBodyPartReceived = new Reference();
        Mockito.when((Object)this.delegate.onBodyPartReceived((HttpResponseBodyPart)org.mockito.Matchers.any())).then(invocation -> {
            classLoaderOnBodyPartReceived.set((Object)Thread.currentThread().getContextClassLoader());
            return null;
        });
        ClassUtils.withContextClassLoader((ClassLoader)this.mockClassLoader, () -> this.asyncHandler.onBodyPartReceived(null));
        Assert.assertThat((Object)classLoaderOnBodyPartReceived.get(), (Matcher)Matchers.is((Object)this.classLoaderOnCreation));
    }

    @Test
    public void creationClassLoaderIsPreservedOnStatusReceived() throws Exception {
        Reference classLoaderOnStatusReceived = new Reference();
        Mockito.when((Object)this.delegate.onStatusReceived((HttpResponseStatus)org.mockito.Matchers.any())).then(invocation -> {
            classLoaderOnStatusReceived.set((Object)Thread.currentThread().getContextClassLoader());
            return null;
        });
        ClassUtils.withContextClassLoader((ClassLoader)this.mockClassLoader, () -> this.asyncHandler.onStatusReceived(null));
        Assert.assertThat((Object)classLoaderOnStatusReceived.get(), (Matcher)Matchers.is((Object)this.classLoaderOnCreation));
    }

    @Test
    public void creationClassLoaderIsPreservedOnHeadersReceived() throws Exception {
        Reference classLoaderOnHeadersReceived = new Reference();
        Mockito.when((Object)this.delegate.onHeadersReceived((HttpResponseHeaders)org.mockito.Matchers.any())).then(invocation -> {
            classLoaderOnHeadersReceived.set((Object)Thread.currentThread().getContextClassLoader());
            return null;
        });
        ClassUtils.withContextClassLoader((ClassLoader)this.mockClassLoader, () -> this.asyncHandler.onHeadersReceived(null));
        Assert.assertThat((Object)classLoaderOnHeadersReceived.get(), (Matcher)Matchers.is((Object)this.classLoaderOnCreation));
    }
}

