/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.http.impl.service.server;

import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.Optional;
import org.apache.http.HttpResponse;
import org.apache.http.StatusLine;
import org.apache.http.client.fluent.Request;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.mule.runtime.api.metadata.MediaType;
import org.mule.runtime.core.api.util.IOUtils;
import org.mule.runtime.http.api.HttpConstants;
import org.mule.runtime.http.api.domain.entity.ByteArrayHttpEntity;
import org.mule.runtime.http.api.domain.entity.HttpEntity;
import org.mule.runtime.http.api.domain.message.response.HttpResponseBuilder;
import org.mule.runtime.http.api.server.async.ResponseStatusCallback;
import org.mule.service.http.impl.functional.AbstractHttpServiceTestCase;
import org.mule.service.http.impl.functional.server.AbstractHttpServerTestCase;
import org.mule.tck.junit4.rule.SystemProperty;

public class HttpServiceEncodedUriTestCase
extends AbstractHttpServerTestCase {
    @Rule
    public SystemProperty encodedSlashes = new SystemProperty("mule.http.service.encoded.slash.enabled", "true");
    private static final String SIMPLE_ENDPOINT = "test";
    private static final String PARAM_ENDPOINT = "test/{value}/test2";
    private static final String SECOND_ENDPOINT = "test/test3";
    private static final String PARAM_SIMPLE_ENDPOINT = "test/{value}";
    private static final String PAYLOAD1 = "p1";
    private static final String PAYLOAD2 = "p2";
    private static final String PAYLOAD3 = "p3";
    private static final String PAYLOAD4 = "p4";

    public HttpServiceEncodedUriTestCase(String serviceToLoad) {
        super(serviceToLoad);
    }

    @Before
    public void setup() {
        System.setProperty("mule.http.service.encoded.slash.enabled", "true");
    }

    @Override
    @After
    public void tearDown() {
        System.clearProperty("mule.http.service.encoded.slash.enabled");
    }

    @Override
    protected String getServerName() {
        return "encoding-slash-test";
    }

    @Before
    public void setUp() throws Exception {
        this.setUpServer();
        this.registerHandler(HttpConstants.Method.GET, SIMPLE_ENDPOINT, PAYLOAD1);
        this.registerHandler(HttpConstants.Method.GET, SECOND_ENDPOINT, PAYLOAD2);
        this.registerHandler(HttpConstants.Method.GET, PARAM_ENDPOINT, PAYLOAD3);
        this.registerHandler(HttpConstants.Method.GET, PARAM_SIMPLE_ENDPOINT, PAYLOAD4);
    }

    private void registerHandler(HttpConstants.Method httpMethod, String endpoint, String payload) {
        this.server.addRequestHandler(Collections.singletonList(httpMethod.name()), "/" + endpoint, (requestContext, responseCallback) -> responseCallback.responseReady(((HttpResponseBuilder)((HttpResponseBuilder)org.mule.runtime.http.api.domain.message.response.HttpResponse.builder().entity((HttpEntity)new ByteArrayHttpEntity(payload.getBytes()))).addHeader("Content-Type", MediaType.TEXT.toRfcString())).build(), (ResponseStatusCallback)new AbstractHttpServiceTestCase.IgnoreResponseStatusCallback()));
    }

    @Test
    public void simpleTest() throws Exception {
        this.assertPostRequestGetsOKResponseStatusAndPayload(SIMPLE_ENDPOINT, Optional.of(PAYLOAD1));
    }

    @Test
    public void withParametersWithoutEncoding() throws Exception {
        this.assertPostRequestGetsOKResponseStatusAndPayload("test/zaraza", Optional.of(PAYLOAD4));
    }

    @Test
    public void withParametersWithEncodedSlash() throws Exception {
        this.assertPostRequestGetsOKResponseStatusAndPayload("test/%2Fzaraza%20%2F", Optional.of(PAYLOAD4));
    }

    @Test
    public void twoNamesUri() throws Exception {
        this.assertPostRequestGetsOKResponseStatusAndPayload(SECOND_ENDPOINT, Optional.of(PAYLOAD2));
    }

    @Test
    public void encodedSlashesDontWorkAsSeparators() throws Exception {
        this.assertPostRequestGetsOKResponseStatusAndPayload("test%2Ftest3");
    }

    @Test
    public void encodedSlashesDontWorkAsSeparatorsEvenEncodingPercentage() throws Exception {
        this.assertPostRequestGetsOKResponseStatusAndPayload("test%252Ftest3");
    }

    @Test
    public void innerParameterCorrectlyTaken() throws Exception {
        this.assertPostRequestGetsOKResponseStatusAndPayload("test/%2Ftest2/test2", Optional.of(PAYLOAD3));
    }

    @Test
    public void innerParameterCorrectlyTakenWithEncodedPercentage() throws Exception {
        this.assertPostRequestGetsOKResponseStatusAndPayload("test/%252Ftest2/test2", Optional.of(PAYLOAD3));
    }

    @Test
    public void innerParameterWithMultipleEncodedSlashesBeginning() throws Exception {
        this.assertPostRequestGetsOKResponseStatusAndPayload("test/%2Fte%20st2%2F/test2/", Optional.of(PAYLOAD3));
    }

    @Test
    public void innerParameterWithMultipleEncodedSlashes() throws Exception {
        this.assertPostRequestGetsOKResponseStatusAndPayload("test/zaraza%2Fte%20st2%2F/test2/", Optional.of(PAYLOAD3));
    }

    @Test
    public void encodedSlashesDontSupresefutureSlashes() throws Exception {
        this.assertPostRequestGetsOKResponseStatusAndPayload("test/%2Fte%20st2%2F/%2F/");
    }

    protected void assertPostRequestGetsOKResponseStatusAndPayload(String endpoint) throws IOException {
        this.assertPostRequestGetsOKResponseStatusAndPayload(endpoint, Optional.empty());
    }

    protected void assertPostRequestGetsOKResponseStatusAndPayload(String endpoint, Optional<String> payload) throws IOException {
        Request request = Request.Get((String)String.format("http://%s:%s/%s", this.server.getServerAddress().getIp(), this.port.getValue(), endpoint));
        HttpResponse response = request.execute().returnResponse();
        StatusLine statusLine = response.getStatusLine();
        if (payload.isPresent()) {
            Assert.assertThat((Object)statusLine.getStatusCode(), (Matcher)Matchers.is((Object)HttpConstants.HttpStatus.OK.getStatusCode()));
            Assert.assertThat((Object)IOUtils.toString((InputStream)response.getEntity().getContent()), (Matcher)Matchers.is((Object)payload.get()));
        } else {
            Assert.assertThat((Object)statusLine.getStatusCode(), (Matcher)Matchers.is((Object)HttpConstants.HttpStatus.NOT_FOUND.getStatusCode()));
        }
    }
}

