/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.http.impl.service.server.grizzly;

import io.qameta.allure.Story;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Collections;
import java.util.OptionalLong;
import java.util.function.Consumer;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.mule.runtime.http.api.HttpConstants;
import org.mule.runtime.http.api.client.HttpClient;
import org.mule.runtime.http.api.client.HttpClientConfiguration;
import org.mule.runtime.http.api.domain.entity.ByteArrayHttpEntity;
import org.mule.runtime.http.api.domain.entity.EmptyHttpEntity;
import org.mule.runtime.http.api.domain.entity.HttpEntity;
import org.mule.runtime.http.api.domain.entity.InputStreamHttpEntity;
import org.mule.runtime.http.api.domain.entity.multipart.HttpPart;
import org.mule.runtime.http.api.domain.entity.multipart.MultipartHttpEntity;
import org.mule.runtime.http.api.domain.message.request.HttpRequest;
import org.mule.runtime.http.api.domain.message.request.HttpRequestBuilder;
import org.mule.runtime.http.api.domain.message.response.HttpResponse;
import org.mule.runtime.http.api.domain.message.response.HttpResponseBuilder;
import org.mule.service.http.impl.functional.client.AbstractHttpClientTestCase;
import org.mule.service.http.impl.service.domain.entity.multipart.StreamedMultipartHttpEntity;
import org.mule.service.http.impl.service.server.grizzly.GrizzlyServerManager;

@Story(value="Transfer Type")
@RunWith(value=Parameterized.class)
public abstract class AbstractHttpTransferLengthTestCase
extends AbstractHttpClientTestCase {
    private static final String RESPONSE = "TEST";
    private static final String REQUEST = "tests";
    private static final String BYTE = "/byte";
    private static final String MULTIPART = "/multipart";
    private static final String STREAM = "/stream";
    private static final String CHUNKED = "/chunked";
    private HttpClient client;
    private boolean isAllowPayloadDefault = GrizzlyServerManager.ALLOW_PAYLOAD_FOR_UNDEFINED_METHODS;

    protected AbstractHttpTransferLengthTestCase(String serviceToLoad, boolean isAllowPayload) {
        super(serviceToLoad);
        GrizzlyServerManager.ALLOW_PAYLOAD_FOR_UNDEFINED_METHODS = isAllowPayload;
    }

    @Before
    public void createClient() {
        HttpClientConfiguration clientConf = new HttpClientConfiguration.Builder().setName("transfer-type-test").build();
        this.client = this.service.getClientFactory().create(clientConf);
        this.client.start();
    }

    @Override
    @After
    public void tearDown() {
        if (this.client != null) {
            this.client.stop();
        }
        GrizzlyServerManager.ALLOW_PAYLOAD_FOR_UNDEFINED_METHODS = this.isAllowPayloadDefault;
    }

    @Override
    protected HttpResponse setUpHttpResponse(HttpRequest request) {
        String path = request.getPath();
        HttpEntity entity = request.getEntity();
        HttpResponseBuilder builder = HttpResponse.builder();
        try {
            OptionalLong expectedRequestLength = OptionalLong.of(REQUEST.length());
            if (BYTE.equals(path)) {
                Assert.assertThat((Object)request.containsHeader("Content-Length"), (Matcher)Matchers.is((Object)true));
                Assert.assertThat((Object)entity, (Matcher)Matchers.is((Matcher)Matchers.instanceOf(InputStreamHttpEntity.class)));
                builder.entity((HttpEntity)new ByteArrayHttpEntity(RESPONSE.getBytes()));
            } else if (MULTIPART.equals(path)) {
                Assert.assertThat((Object)request.containsHeader("Content-Length"), (Matcher)Matchers.is((Object)true));
                expectedRequestLength = OptionalLong.of(142L);
                Assert.assertThat((Object)entity, (Matcher)Matchers.is((Matcher)Matchers.instanceOf(StreamedMultipartHttpEntity.class)));
                HttpPart part = new HttpPart("part1", RESPONSE.getBytes(), "text/plain", 4);
                ((HttpResponseBuilder)builder.entity((HttpEntity)new MultipartHttpEntity(Collections.singletonList(part)))).addHeader("Content-Type", "multipart/form-data; boundary=\"bounds\"");
            } else if (STREAM.equals(path)) {
                Assert.assertThat((Object)request.containsHeader("Content-Length"), (Matcher)Matchers.is((Object)true));
                Assert.assertThat((Object)entity, (Matcher)Matchers.is((Matcher)Matchers.instanceOf(InputStreamHttpEntity.class)));
                builder.entity((HttpEntity)new InputStreamHttpEntity((InputStream)new ByteArrayInputStream(RESPONSE.getBytes()), 4L));
            } else if (CHUNKED.equals(path)) {
                Assert.assertThat((Object)request.containsHeader("Content-Length"), (Matcher)Matchers.is((Object)false));
                Assert.assertThat((Object)entity, (Matcher)Matchers.is((Matcher)Matchers.instanceOf(InputStreamHttpEntity.class)));
                expectedRequestLength = OptionalLong.empty();
                builder.entity((HttpEntity)new InputStreamHttpEntity((InputStream)new ByteArrayInputStream(RESPONSE.getBytes())));
            } else {
                Assert.assertThat((Object)request.containsHeader("Content-Length"), (Matcher)Matchers.is((Object)false));
                expectedRequestLength = OptionalLong.of(0L);
                Assert.assertThat((Object)entity, (Matcher)Matchers.is((Matcher)Matchers.instanceOf(EmptyHttpEntity.class)));
            }
            Assert.assertThat((Object)request.getEntity().getBytesLength(), (Matcher)Matchers.is((Object)expectedRequestLength));
            return builder.build();
        }
        catch (AssertionError e) {
            return ((HttpResponseBuilder)builder.statusCode(Integer.valueOf(500)).entity((HttpEntity)new ByteArrayHttpEntity(((Throwable)((Object)e)).getMessage().getBytes()))).build();
        }
    }

    @Test
    public void propagatesLengthWhenByte() throws Exception {
        HttpRequest request = ((HttpRequestBuilder)HttpRequest.builder().uri(this.getUri() + BYTE).entity((HttpEntity)new ByteArrayHttpEntity(REQUEST.getBytes()))).build();
        this.send(request, false, response -> {
            Assert.assertThat((Object)response.getEntity().getBytesLength().getAsLong(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)4L)));
            Assert.assertThat((Object)response.getEntity(), (Matcher)Matchers.instanceOf(InputStreamHttpEntity.class));
        });
    }

    @Test
    public void propagatesLengthWhenMultipart() throws Exception {
        HttpPart part = new HttpPart("part1", REQUEST.getBytes(), "text/plain", 5);
        HttpRequest request = ((HttpRequestBuilder)((HttpRequestBuilder)HttpRequest.builder().uri(this.getUri() + MULTIPART).addHeader("Content-Type", "multipart/form-data; boundary=\"bounds\"")).entity((HttpEntity)new MultipartHttpEntity(Collections.singletonList(part)))).build();
        this.send(request, false, response -> {
            Assert.assertThat((Object)response.getEntity().getBytesLength().getAsLong(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)102L)));
            Assert.assertThat((Object)response.getEntity(), (Matcher)Matchers.instanceOf(StreamedMultipartHttpEntity.class));
        });
    }

    @Test
    public void propagatesLengthWhenEmpty() throws Exception {
        HttpRequest request = HttpRequest.builder().uri(this.getUri() + "/empty").build();
        this.send(request, true, response -> {
            Assert.assertThat((Object)response.getEntity().getBytesLength().getAsLong(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)0L)));
            Assert.assertThat((Object)response.getEntity(), (Matcher)Matchers.instanceOf(EmptyHttpEntity.class));
        });
    }

    @Test
    public void propagatesLengthWhenStream() throws Exception {
        HttpRequest request = ((HttpRequestBuilder)HttpRequest.builder().uri(this.getUri() + STREAM).entity((HttpEntity)new InputStreamHttpEntity((InputStream)new ByteArrayInputStream(REQUEST.getBytes()), 5L))).build();
        this.send(request, false, response -> {
            Assert.assertThat((Object)response.getEntity().getBytesLength().getAsLong(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)4L)));
            Assert.assertThat((Object)response.getEntity(), (Matcher)Matchers.instanceOf(InputStreamHttpEntity.class));
        });
    }

    @Test
    public void doesNotPropagateLengthWhenChunked() throws Exception {
        HttpRequest request = ((HttpRequestBuilder)HttpRequest.builder().uri(this.getUri() + CHUNKED).entity((HttpEntity)new InputStreamHttpEntity((InputStream)new ByteArrayInputStream(REQUEST.getBytes())))).build();
        this.send(request, false, response -> {
            Assert.assertThat((Object)response.getEntity().getBytesLength(), (Matcher)Matchers.is((Object)OptionalLong.empty()));
            Assert.assertThat((Object)response.getEntity(), (Matcher)Matchers.instanceOf(InputStreamHttpEntity.class));
        });
    }

    private void send(HttpRequest request, boolean hasEmptyPayload, Consumer<HttpResponse> onSuccessResponse) throws Exception {
        HttpResponse response = this.client.send(request, this.getDefaultOptions(10000));
        if (GrizzlyServerManager.ALLOW_PAYLOAD_FOR_UNDEFINED_METHODS || hasEmptyPayload) {
            Assert.assertThat((Object)response.getStatusCode(), (Matcher)Matchers.is((Object)HttpConstants.HttpStatus.OK.getStatusCode()));
            onSuccessResponse.accept(response);
        } else {
            Assert.assertThat((Object)response.getStatusCode(), (Matcher)Matchers.is((Object)HttpConstants.HttpStatus.BAD_REQUEST.getStatusCode()));
        }
    }
}

