/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.http.impl.service.client;

import com.ning.http.client.Request;
import com.ning.http.client.RequestBuilder;
import com.ning.http.client.providers.grizzly.FeedableBodyGenerator;
import io.qameta.allure.Issue;
import java.io.IOException;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnit;
import org.mockito.junit.MockitoRule;
import org.mule.runtime.api.util.MultiMap;
import org.mule.runtime.http.api.client.HttpRequestOptions;
import org.mule.runtime.http.api.domain.entity.HttpEntity;
import org.mule.runtime.http.api.domain.message.request.HttpRequest;
import org.mule.service.http.impl.service.client.GrizzlyHttpClient;
import org.mule.service.http.impl.service.client.GrizzlyRequestConfigurer;

public class GrizzlyRequestConfigurerTestCase {
    @Rule
    public MockitoRule mockitorule = MockitoJUnit.rule();
    @Mock
    private GrizzlyHttpClient client;
    @Mock
    private HttpRequestOptions options;

    @Test
    @Issue(value="MULE-19424")
    public void theGrizzlyRequestIsConfiguredWithAFeedableBodyGeneratorWhenStreamingIsEnable() throws IOException {
        boolean requestStreamingEnabled = true;
        Request grizzlyRequest = this.configureGrizzlyRequest(requestStreamingEnabled);
        Assert.assertThat((Object)grizzlyRequest.getBodyGenerator(), (Matcher)Matchers.instanceOf(FeedableBodyGenerator.class));
    }

    @Test
    @Issue(value="MULE-19424")
    public void theGrizzlyRequestIsNotConfiguredWithAFeedableBodyGeneratorWhenStreamingIsDisabled() throws IOException {
        boolean isRequestStreamingEnabled = false;
        Request grizzlyRequest = this.configureGrizzlyRequest(isRequestStreamingEnabled);
        Assert.assertThat((Object)grizzlyRequest.getBodyGenerator(), (Matcher)Matchers.not((Matcher)Matchers.instanceOf(FeedableBodyGenerator.class)));
    }

    private HttpRequest mockMuleRequestWithStreamingEntity() {
        HttpRequest muleRequest = (HttpRequest)Mockito.mock(HttpRequest.class);
        HttpEntity requestEntity = (HttpEntity)Mockito.mock(HttpEntity.class);
        Mockito.when((Object)requestEntity.isStreaming()).thenReturn((Object)true);
        Mockito.when((Object)muleRequest.getMethod()).thenReturn((Object)"POST");
        Mockito.when((Object)muleRequest.getQueryParams()).thenReturn((Object)MultiMap.emptyMultiMap());
        Mockito.when((Object)muleRequest.getEntity()).thenReturn((Object)requestEntity);
        return muleRequest;
    }

    private Request configureGrizzlyRequest(boolean isRequestStreamingEnabled) throws IOException {
        HttpRequest muleRequest = this.mockMuleRequestWithStreamingEntity();
        RequestBuilder requestBuilder = new RequestBuilder(muleRequest.getMethod(), true);
        GrizzlyRequestConfigurer configurer = new GrizzlyRequestConfigurer(this.client, this.options, muleRequest, false, isRequestStreamingEnabled, 8192);
        configurer.configure(requestBuilder);
        return requestBuilder.build();
    }
}

