/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.http.impl.service.server;

import io.qameta.allure.Description;
import io.qameta.allure.Issue;
import java.util.function.Supplier;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mule.runtime.api.scheduler.Scheduler;
import org.mule.runtime.api.scheduler.SchedulerConfig;
import org.mule.runtime.api.scheduler.SchedulerService;
import org.mule.runtime.http.api.server.HttpServerConfiguration;
import org.mule.runtime.http.api.server.ServerAddress;
import org.mule.service.http.impl.service.server.HttpListenerConnectionManager;
import org.mule.service.http.impl.service.server.ServerIdentifier;
import org.mule.service.http.impl.service.server.grizzly.GrizzlyServerManager;

public class HttpListenerConnectionManagerTestCase {
    private GrizzlyServerManager grizzlyServerManager;

    @Test
    @Issue(value="MULE-19779")
    @Description(value="Tests that, when specified, the read timeout is set to a custom value")
    public void setCustomReadTimeoutTo20secs() throws Exception {
        SchedulerService schedulerServiceMock = (SchedulerService)Mockito.mock(SchedulerService.class);
        SchedulerConfig schedulerConfigMock = (SchedulerConfig)Mockito.mock(SchedulerConfig.class);
        Scheduler scheduler = (Scheduler)Mockito.mock(Scheduler.class);
        long readTimeout = 20000L;
        HttpServerConfiguration serverConfiguration = new HttpServerConfiguration.Builder().setName("CONFIG_NAME").setHost("localhost").setPort(8081).setReadTimeout(readTimeout).build();
        long shutdownTimeout = 50L;
        Mockito.when((Object)schedulerServiceMock.customScheduler((SchedulerConfig)ArgumentMatchers.any())).thenReturn((Object)scheduler);
        Mockito.when((Object)schedulerServiceMock.ioScheduler((SchedulerConfig)ArgumentMatchers.any())).thenReturn((Object)scheduler);
        Mockito.when((Object)schedulerConfigMock.withMaxConcurrentTasks(((Integer)ArgumentMatchers.any(Integer.TYPE)).intValue())).thenReturn((Object)schedulerConfigMock);
        Mockito.when((Object)schedulerConfigMock.withName((String)ArgumentMatchers.any())).thenReturn((Object)schedulerConfigMock);
        TestHttpListenerConnectionManager httpListenerConnectionManager = new TestHttpListenerConnectionManager(schedulerServiceMock, schedulerConfigMock);
        httpListenerConnectionManager.initialise();
        httpListenerConnectionManager.create(serverConfiguration, "context", () -> shutdownTimeout);
        ((GrizzlyServerManager)Mockito.verify((Object)this.grizzlyServerManager)).createServerFor((ServerAddress)ArgumentMatchers.any(), (Supplier)ArgumentMatchers.any(), ((Boolean)ArgumentMatchers.any(Boolean.TYPE)).booleanValue(), ((Integer)ArgumentMatchers.any(Integer.TYPE)).intValue(), (ServerIdentifier)ArgumentMatchers.any(), (Supplier)ArgumentMatchers.any(), ArgumentMatchers.eq((long)readTimeout));
    }

    @Test
    @Issue(value="MULE-19779")
    @Description(value="Tests that by default the read timeout is set to 30 seconds")
    public void setDefaultReadTimeoutTo30secs() throws Exception {
        SchedulerService schedulerServiceMock = (SchedulerService)Mockito.mock(SchedulerService.class);
        SchedulerConfig schedulerConfigMock = (SchedulerConfig)Mockito.mock(SchedulerConfig.class);
        Scheduler scheduler = (Scheduler)Mockito.mock(Scheduler.class);
        long readTimeout = 30000L;
        HttpServerConfiguration serverConfiguration = new HttpServerConfiguration.Builder().setName("CONFIG_NAME").setHost("localhost").setPort(8081).build();
        long shutdownTimeout = 50L;
        Mockito.when((Object)schedulerServiceMock.customScheduler((SchedulerConfig)ArgumentMatchers.any())).thenReturn((Object)scheduler);
        Mockito.when((Object)schedulerServiceMock.ioScheduler((SchedulerConfig)ArgumentMatchers.any())).thenReturn((Object)scheduler);
        Mockito.when((Object)schedulerConfigMock.withMaxConcurrentTasks(((Integer)ArgumentMatchers.any(Integer.TYPE)).intValue())).thenReturn((Object)schedulerConfigMock);
        Mockito.when((Object)schedulerConfigMock.withName((String)ArgumentMatchers.any())).thenReturn((Object)schedulerConfigMock);
        TestHttpListenerConnectionManager httpListenerConnectionManager = new TestHttpListenerConnectionManager(schedulerServiceMock, schedulerConfigMock);
        httpListenerConnectionManager.initialise();
        httpListenerConnectionManager.create(serverConfiguration, "context", () -> shutdownTimeout);
        ((GrizzlyServerManager)Mockito.verify((Object)this.grizzlyServerManager)).createServerFor((ServerAddress)ArgumentMatchers.any(), (Supplier)ArgumentMatchers.any(), ((Boolean)ArgumentMatchers.any(Boolean.TYPE)).booleanValue(), ((Integer)ArgumentMatchers.any(Integer.TYPE)).intValue(), (ServerIdentifier)ArgumentMatchers.any(), (Supplier)ArgumentMatchers.any(), ArgumentMatchers.eq((long)readTimeout));
    }

    class TestHttpListenerConnectionManager
    extends HttpListenerConnectionManager {
        public TestHttpListenerConnectionManager(SchedulerService schedulerService, SchedulerConfig schedulersConfig) {
            super(schedulerService, schedulersConfig);
        }

        public GrizzlyServerManager createServerManager() {
            HttpListenerConnectionManagerTestCase.this.grizzlyServerManager = (GrizzlyServerManager)Mockito.mock(GrizzlyServerManager.class);
            return HttpListenerConnectionManagerTestCase.this.grizzlyServerManager;
        }
    }
}

