/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.http.impl.service.server.grizzly;

import java.util.ArrayList;
import java.util.List;
import javax.mail.BodyPart;
import javax.mail.internet.MimeMultipart;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.mule.runtime.http.api.domain.entity.HttpEntity;
import org.mule.runtime.http.api.domain.entity.multipart.HttpPart;
import org.mule.service.http.impl.service.server.grizzly.HttpMultipartEncoder;
import org.mule.tck.junit4.AbstractMuleTestCase;

public class HttpMultipartEncoderTestCase
extends AbstractMuleTestCase {
    private static final String FIRST_PART_CONTENT = "first-part-test";
    private static final String SECOND_PART_CONTENT = "second-part-test";
    private static final String THIRD_PART_CONTENT = "third-part-test";
    private static final String FORTH_PART_CONTENT = "{ \"test\" : \"forth-part-test\"}";
    private final List<HttpPart> httpParts = new ArrayList<HttpPart>();
    private final HttpEntity httpEntity = (HttpEntity)Mockito.mock(HttpEntity.class);

    @Before
    public void setUp() throws Exception {
        HttpPart firstPart = new HttpPart("firstPart", FIRST_PART_CONTENT.getBytes(), "text/plain", FIRST_PART_CONTENT.getBytes().length);
        this.httpParts.add(firstPart);
        HttpPart secondPart = new HttpPart("secondPart", SECOND_PART_CONTENT.getBytes(), "text/plain", SECOND_PART_CONTENT.getBytes().length);
        this.httpParts.add(secondPart);
        HttpPart thirdPart = new HttpPart("thirdPart", THIRD_PART_CONTENT.getBytes(), "text/plain", THIRD_PART_CONTENT.getBytes().length);
        this.httpParts.add(thirdPart);
        Mockito.when((Object)this.httpEntity.getParts()).thenReturn(this.httpParts);
    }

    @Test
    public void createMultipartRelatedContentWithStartParameter() throws Exception {
        MimeMultipart mimeMultipart = HttpMultipartEncoder.toMimeMultipart((HttpEntity)this.httpEntity, (String)"multipart/related; boundary= \"MIMEBoundary\"; type=\"text/plain\"; start=thirdPart");
        this.verifyBodyPart(mimeMultipart.getBodyPart(0), THIRD_PART_CONTENT, "thirdPart");
        this.verifyBodyPart(mimeMultipart.getBodyPart(1), FIRST_PART_CONTENT, "firstPart");
        this.verifyBodyPart(mimeMultipart.getBodyPart(2), SECOND_PART_CONTENT, "secondPart");
        Assert.assertThat((Object)mimeMultipart.getContentType(), (Matcher)CoreMatchers.containsString((String)"type=\"text/plain\""));
    }

    @Test
    public void createMultipartRelatedContentWithoutStartParameter() throws Exception {
        MimeMultipart mimeMultipart = HttpMultipartEncoder.toMimeMultipart((HttpEntity)this.httpEntity, (String)"multipart/related; boundary=\"MIMEBoundary\"; type=\"text/plain\";");
        this.verifyBodyPart(mimeMultipart.getBodyPart(0), FIRST_PART_CONTENT, "firstPart");
        this.verifyBodyPart(mimeMultipart.getBodyPart(1), SECOND_PART_CONTENT, "secondPart");
        this.verifyBodyPart(mimeMultipart.getBodyPart(2), THIRD_PART_CONTENT, "thirdPart");
        Assert.assertThat((Object)mimeMultipart.getContentType(), (Matcher)CoreMatchers.containsString((String)"type=\"text/plain\""));
    }

    @Test
    public void createMultipartRelatedContentWithoutMandatoryTypeParameter() throws Exception {
        try {
            HttpMultipartEncoder.toMimeMultipart((HttpEntity)this.httpEntity, (String)"multipart/related; boundary=\"MIMEBoundary\"");
            Assert.fail((String)"Exception caused by no present type should be triggered");
        }
        catch (Exception e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.is((Object)"Type parameter is not present in multipart/related content type, but it is mandatory."));
        }
    }

    @Test
    public void createMultipartRelatedContentWithAmbiguousType() throws Exception {
        HttpPart forthPart = new HttpPart("forthPart", FORTH_PART_CONTENT.getBytes(), "application/json", FORTH_PART_CONTENT.getBytes().length);
        this.httpParts.add(forthPart);
        try {
            HttpMultipartEncoder.toMimeMultipart((HttpEntity)this.httpEntity, (String)"multipart/related; boundary=\"MIMEBoundary\"; type=\"text/plain\"; start=forthPart");
            Assert.fail((String)"Exception caused by ambiguous type should be triggered");
        }
        catch (Exception e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.is((Object)"Type parameter and root body part content type must be the same."));
        }
    }

    private void verifyBodyPart(BodyPart bodyPart, String content, String name) throws Exception {
        Assert.assertThat((Object)bodyPart.getContent(), (Matcher)CoreMatchers.is((Object)content));
        Assert.assertThat((Object)bodyPart.getHeader("Content-Id")[0], (Matcher)CoreMatchers.is((Object)name));
    }
}

