/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.http.impl.service.client;

import com.ning.http.client.RequestBuilder;
import com.ning.http.client.cookie.Cookie;
import io.qameta.allure.Issue;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnit;
import org.mockito.junit.MockitoRule;
import org.mule.runtime.http.api.domain.entity.HttpEntity;
import org.mule.runtime.http.api.domain.message.request.HttpRequest;
import org.mule.service.http.impl.service.client.RequestHeaderPopulator;
import org.mule.tck.junit4.AbstractMuleTestCase;

public class RequestHeaderPopulatorTestCase
extends AbstractMuleTestCase {
    @Rule
    public MockitoRule mockitorule = MockitoJUnit.rule();
    @Mock
    private HttpRequest muleRequest;
    private RequestBuilder ahcRequestBuilder;
    @Mock
    private HttpEntity httpEntity;
    private List<String> headerNames;
    private RequestHeaderPopulator populator;

    @Before
    public void setUp() {
        Assume.assumeThat((Object)Boolean.getBoolean("mule.http.cookie.special.handling.disable"), (Matcher)Matchers.is((Object)false));
        this.ahcRequestBuilder = new RequestBuilder();
        this.headerNames = new ArrayList<String>();
        Mockito.when((Object)this.muleRequest.getEntity()).thenReturn((Object)this.httpEntity);
        Mockito.when((Object)this.muleRequest.getHeaderNames()).thenReturn(this.headerNames);
        this.populator = new RequestHeaderPopulator(true);
    }

    @Test
    public void singleCookiePair() {
        this.headerNames.add("Cookie".toLowerCase());
        Mockito.when((Object)this.muleRequest.getHeaderValues("Cookie".toLowerCase())).thenReturn(Collections.singletonList("Name=Value"));
        this.populator.populateHeaders(this.muleRequest, this.ahcRequestBuilder);
        Collection<String> cookiesInRequestAsString = RequestHeaderPopulatorTestCase.getCookiesAsStrings(this.ahcRequestBuilder);
        Assert.assertThat(cookiesInRequestAsString, (Matcher)Matchers.contains((Object[])new String[]{"Name=Value"}));
    }

    @Test
    @Issue(value="W-12666590")
    public void cookieHeaderWithNullValue() {
        this.headerNames.add("Cookie".toLowerCase());
        Mockito.when((Object)this.muleRequest.getHeaderValues("Cookie".toLowerCase())).thenReturn(Collections.singletonList(null));
        this.populator.populateHeaders(this.muleRequest, this.ahcRequestBuilder);
    }

    @Test
    @Issue(value="W-12666590")
    public void cookieHeadersCollectionWithNullValue() {
        this.headerNames.add("Cookie".toLowerCase());
        Mockito.when((Object)this.muleRequest.getHeaderValues("Cookie".toLowerCase())).thenReturn(null);
        this.populator.populateHeaders(this.muleRequest, this.ahcRequestBuilder);
    }

    @Test
    @Issue(value="W-12528819")
    public void cookieWithSecureAndHttpOnly() {
        this.headerNames.add("Cookie".toLowerCase());
        Mockito.when((Object)this.muleRequest.getHeaderValues("Cookie".toLowerCase())).thenReturn(Collections.singletonList("Name=Value; secure; HttpOnly"));
        this.populator.populateHeaders(this.muleRequest, this.ahcRequestBuilder);
        Collection<String> cookiesInRequestAsString = RequestHeaderPopulatorTestCase.getCookiesAsStrings(this.ahcRequestBuilder);
        Assert.assertThat(cookiesInRequestAsString, (Matcher)Matchers.contains((Object[])new String[]{"Name=Value"}));
    }

    private static Collection<String> getCookiesAsStrings(RequestBuilder requestBuilder) {
        return requestBuilder.build().getCookies().stream().map(Cookie::toString).collect(Collectors.toList());
    }
}

