/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.http.impl.config;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Properties;
import java.util.function.Consumer;
import org.mule.runtime.api.exception.DefaultMuleException;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.http.api.tcp.TcpServerSocketProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContainerTcpServerSocketProperties
implements TcpServerSocketProperties {
    public static final String SERVER_SOCKETS_FILE = "mule.httpServerSockets.confFile";
    public static final String PROPERTY_PREFIX = "org.mule.runtime.http.server.socket.";
    private static final Logger LOGGER = LoggerFactory.getLogger(ContainerTcpServerSocketProperties.class);
    private Integer sendBufferSize;
    private Integer receiveBufferSize;
    private Integer clientTimeout;
    private Boolean sendTcpNoDelay = true;
    private Integer linger;
    private Boolean keepAlive = false;
    private Boolean reuseAddress = true;
    private Integer receiveBacklog = 50;
    private Integer serverTimeout = 60000;

    private ContainerTcpServerSocketProperties() {
    }

    public static ContainerTcpServerSocketProperties loadTcpServerSocketProperties() throws MuleException {
        File configFile;
        ContainerTcpServerSocketProperties socketProperties = new ContainerTcpServerSocketProperties();
        String overrideFile = System.getProperty(SERVER_SOCKETS_FILE);
        if (overrideFile != null) {
            configFile = new File(overrideFile);
        } else {
            File muleHome;
            File file = muleHome = System.getProperty("mule.home") != null ? new File(System.getProperty("mule.home")) : null;
            if (muleHome == null) {
                LOGGER.info("No mule.home defined. Using default server sockets configuration.");
                return socketProperties;
            }
            configFile = new File(muleHome, "conf" + File.separator + "http-server-sockets.conf");
        }
        if (!configFile.exists()) {
            LOGGER.info("Server sockets config file not found. Using default values.");
            return socketProperties;
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Loading server sockets configuration from " + configFile.getPath());
        }
        Properties properties = new Properties();
        try (FileInputStream configIs = new FileInputStream(configFile);){
            properties.load(configIs);
        }
        catch (IOException e) {
            throw new DefaultMuleException((Throwable)e);
        }
        ContainerTcpServerSocketProperties.ifPresent("sendBufferSize", properties, p -> socketProperties.setSendBufferSize(Integer.valueOf(p)));
        ContainerTcpServerSocketProperties.ifPresent("receiveBufferSize", properties, p -> socketProperties.setReceiveBufferSize(Integer.valueOf(p)));
        ContainerTcpServerSocketProperties.ifPresent("clientTimeout", properties, p -> socketProperties.setClientTimeout(Integer.valueOf(p)));
        ContainerTcpServerSocketProperties.ifPresent("sendTcpNoDelay", properties, p -> socketProperties.setSendTcpNoDelay(Boolean.valueOf(p)));
        ContainerTcpServerSocketProperties.ifPresent("linger", properties, p -> socketProperties.setLinger(Integer.valueOf(p)));
        ContainerTcpServerSocketProperties.ifPresent("keepAlive", properties, p -> socketProperties.setKeepAlive(Boolean.valueOf(p)));
        ContainerTcpServerSocketProperties.ifPresent("reuseAddress", properties, p -> socketProperties.setReuseAddress(Boolean.valueOf(p)));
        ContainerTcpServerSocketProperties.ifPresent("receiveBacklog", properties, p -> socketProperties.setReceiveBacklog(Integer.valueOf(p)));
        ContainerTcpServerSocketProperties.ifPresent("serverTimeout", properties, p -> socketProperties.setServerTimeout(Integer.valueOf(p)));
        return socketProperties;
    }

    private static void ifPresent(String propertyName, Properties properties, Consumer<String> operation) {
        String property = properties.getProperty(PROPERTY_PREFIX + propertyName);
        if (property != null) {
            operation.accept(property);
        }
    }

    public Integer getSendBufferSize() {
        return this.sendBufferSize;
    }

    public Integer getReceiveBufferSize() {
        return this.receiveBufferSize;
    }

    public Integer getClientTimeout() {
        return this.clientTimeout;
    }

    public Boolean getSendTcpNoDelay() {
        return this.sendTcpNoDelay;
    }

    public Integer getLinger() {
        return this.linger;
    }

    public Boolean getKeepAlive() {
        return this.keepAlive;
    }

    public Boolean getReuseAddress() {
        return this.reuseAddress;
    }

    public Integer getReceiveBacklog() {
        return this.receiveBacklog;
    }

    public Integer getServerTimeout() {
        return this.serverTimeout;
    }

    private void setSendBufferSize(Integer sendBufferSize) {
        this.sendBufferSize = sendBufferSize;
    }

    private void setReceiveBufferSize(Integer receiveBufferSize) {
        this.receiveBufferSize = receiveBufferSize;
    }

    private void setClientTimeout(Integer clientTimeout) {
        this.clientTimeout = clientTimeout;
    }

    private void setSendTcpNoDelay(Boolean sendTcpNoDelay) {
        this.sendTcpNoDelay = sendTcpNoDelay;
    }

    private void setLinger(Integer linger) {
        this.linger = linger;
    }

    private void setKeepAlive(Boolean keepAlive) {
        this.keepAlive = keepAlive;
    }

    private void setReuseAddress(Boolean reuseAddress) {
        this.reuseAddress = reuseAddress;
    }

    private void setReceiveBacklog(Integer receiveBacklog) {
        this.receiveBacklog = receiveBacklog;
    }

    private void setServerTimeout(Integer serverTimeout) {
        this.serverTimeout = serverTimeout;
    }
}

