/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.http.impl.functional.client;

import io.qameta.allure.Story;
import java.util.Collection;
import java.util.Collections;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mule.runtime.api.lifecycle.CreateException;
import org.mule.runtime.api.tls.TlsContextFactory;
import org.mule.runtime.http.api.HttpConstants;
import org.mule.runtime.http.api.client.HttpClient;
import org.mule.runtime.http.api.client.HttpClientConfiguration;
import org.mule.runtime.http.api.domain.entity.ByteArrayHttpEntity;
import org.mule.runtime.http.api.domain.entity.HttpEntity;
import org.mule.runtime.http.api.domain.entity.multipart.HttpPart;
import org.mule.runtime.http.api.domain.entity.multipart.MultipartHttpEntity;
import org.mule.runtime.http.api.domain.message.request.HttpRequest;
import org.mule.runtime.http.api.domain.message.request.HttpRequestBuilder;
import org.mule.runtime.http.api.domain.message.response.HttpResponse;
import org.mule.runtime.http.api.domain.message.response.HttpResponseBuilder;
import org.mule.runtime.http.api.server.HttpServerConfiguration;
import org.mule.runtime.http.api.tcp.TcpClientSocketProperties;
import org.mule.service.http.impl.functional.client.AbstractHttpClientTestCase;

@Story(value="Multipart")
public class HttpClientOutboundPartsTestCase
extends AbstractHttpClientTestCase {
    private static final String PASS = "mulepassword";
    private static final int SEND_BUFFER_SIZE = 128;
    private static final String TEXT_PLAIN = "text/plain";
    private HttpClient client;

    public HttpClientOutboundPartsTestCase(String serviceToLoad) {
        super(serviceToLoad);
    }

    @Before
    public void createClient() throws CreateException {
        this.client = this.service.getClientFactory().create(new HttpClientConfiguration.Builder().setTlsContextFactory(TlsContextFactory.builder().trustStorePath("tls/trustStore").trustStorePassword(PASS).build()).setClientSocketProperties(TcpClientSocketProperties.builder().sendBufferSize(Integer.valueOf(128)).build()).setName("multipart-test").build());
        this.client.start();
    }

    @After
    public void stopClient() {
        if (this.client != null) {
            this.client.stop();
        }
    }

    @Test
    public void sendingAttachmentBiggerThanAsyncWriteQueueSizeWorksOverHttps() throws Exception {
        int maxAsyncWriteQueueSize = 512;
        int size = maxAsyncWriteQueueSize * 2;
        HttpPart part = new HttpPart("part1", new byte[size], TEXT_PLAIN, size);
        HttpResponse response = this.client.send(((HttpRequestBuilder)HttpRequest.builder().method(HttpConstants.Method.POST).uri(this.getUri()).entity((HttpEntity)new MultipartHttpEntity(Collections.singletonList(part)))).build(), this.getDefaultOptions(10000));
        Assert.assertThat((Object)response.getStatusCode(), (Matcher)Matchers.is((Object)HttpConstants.HttpStatus.OK.getStatusCode()));
    }

    @Override
    protected HttpServerConfiguration.Builder getServerConfigurationBuilder() throws Exception {
        return super.getServerConfigurationBuilder().setTlsContextFactory(TlsContextFactory.builder().keyStorePath("tls/serverKeystore").keyStorePassword(PASS).keyPassword(PASS).build());
    }

    @Override
    protected String getUri() {
        return super.getUri().replace(HttpConstants.Protocol.HTTP.getScheme(), HttpConstants.Protocol.HTTPS.getScheme());
    }

    @Override
    protected HttpResponse setUpHttpResponse(HttpRequest request) {
        HttpResponseBuilder response = HttpResponse.builder();
        try {
            Collection parts = request.getEntity().getParts();
            Assert.assertThat((Object)parts, (Matcher)Matchers.hasSize((int)1));
            HttpPart part = (HttpPart)parts.iterator().next();
            Assert.assertThat((Object)part.getName(), (Matcher)Matchers.is((Object)"part1"));
            Assert.assertThat((Object)part.getContentType(), (Matcher)Matchers.is((Object)TEXT_PLAIN));
            return ((HttpResponseBuilder)response.statusCode(Integer.valueOf(HttpConstants.HttpStatus.OK.getStatusCode())).entity((HttpEntity)new ByteArrayHttpEntity(HttpConstants.HttpStatus.OK.getReasonPhrase().getBytes()))).build();
        }
        catch (Exception exception) {
            return response.statusCode(Integer.valueOf(HttpConstants.HttpStatus.INTERNAL_SERVER_ERROR.getStatusCode())).build();
        }
    }
}

