/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.http.impl.functional.client;

import io.qameta.allure.Description;
import io.qameta.allure.Issue;
import java.io.IOException;
import java.util.concurrent.TimeoutException;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mule.runtime.http.api.HttpConstants;
import org.mule.runtime.http.api.client.HttpClient;
import org.mule.runtime.http.api.client.HttpClientConfiguration;
import org.mule.runtime.http.api.domain.entity.ByteArrayHttpEntity;
import org.mule.runtime.http.api.domain.entity.HttpEntity;
import org.mule.runtime.http.api.domain.message.request.HttpRequest;
import org.mule.runtime.http.api.domain.message.response.HttpResponse;
import org.mule.runtime.http.api.domain.message.response.HttpResponseBuilder;
import org.mule.service.http.impl.functional.client.AbstractHttpClientTestCase;

public class GrizzlyHttpRequest100ContinueTestCase
extends AbstractHttpClientTestCase {
    private static final String RESPONSE = "Messi, Messi, Messi, fubol, fubol, fubol";
    private HttpClient client;

    public GrizzlyHttpRequest100ContinueTestCase(String serviceToLoad) {
        super(serviceToLoad);
    }

    @Before
    public void createClient() {
        this.client = this.service.getClientFactory().create(new HttpClientConfiguration.Builder().setName("ignore-100-continue").build());
        this.client.start();
    }

    @After
    public void stopClient() {
        if (this.client != null) {
            this.client.stop();
        }
    }

    @Test
    @Issue(value="W-13806048")
    @Description(value="If the server sends an 'Expect' header, it should be ignored and not fail")
    public void expect100isIgnored() throws IOException, TimeoutException {
        HttpResponse response = this.client.send(HttpRequest.builder().uri(this.getUri()).build());
        Assert.assertThat((Object)response.getStatusCode(), (Matcher)Matchers.is((Object)HttpConstants.HttpStatus.OK.getStatusCode()));
        Assert.assertThat((Object)response.getEntity().getBytesLength().isPresent(), (Matcher)Matchers.is((Object)true));
        Assert.assertThat((Object)new String(response.getEntity().getBytes()), (Matcher)Matchers.is((Object)RESPONSE));
    }

    @Override
    protected HttpResponse setUpHttpResponse(HttpRequest request) {
        return ((HttpResponseBuilder)((HttpResponseBuilder)HttpResponse.builder().statusCode(Integer.valueOf(HttpConstants.HttpStatus.OK.getStatusCode())).addHeader("Expect", "100-continue")).entity((HttpEntity)new ByteArrayHttpEntity(RESPONSE.getBytes()))).build();
    }
}

