/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.http.impl.functional.client;

import org.junit.After;
import org.junit.Rule;
import org.mule.runtime.core.api.util.ClassUtils;
import org.mule.runtime.http.api.domain.message.request.HttpRequest;
import org.mule.runtime.http.api.domain.message.response.HttpResponse;
import org.mule.runtime.http.api.server.HttpServer;
import org.mule.runtime.http.api.server.HttpServerConfiguration;
import org.mule.runtime.http.api.server.RequestHandler;
import org.mule.runtime.http.api.server.async.ResponseStatusCallback;
import org.mule.service.http.impl.functional.AbstractHttpServiceTestCase;
import org.mule.service.http.impl.functional.client.AbstractHttpClientTestCase;
import org.mule.tck.junit4.rule.DynamicPort;

public abstract class AbstractHttpRedirectClientTestCase
extends AbstractHttpClientTestCase {
    @Rule
    public DynamicPort redirectPort = new DynamicPort("port");
    protected HttpServer redirectServer;

    public AbstractHttpRedirectClientTestCase(String serviceToLoad) {
        super(serviceToLoad);
    }

    @Override
    public void setUp() throws Exception {
        this.redirectServer = this.service.getServerFactory().create(this.getRedirectServerConfigurationBuilder().build());
        this.redirectServer.start();
        RequestHandler requestHandler = this.getRedirectRequestHandler();
        ClassUtils.withContextClassLoader((ClassLoader)requestHandler.getContextClassLoader(), () -> this.redirectServer.addRequestHandler("/*", requestHandler));
        super.setUp();
    }

    protected HttpServerConfiguration.Builder getRedirectServerConfigurationBuilder() {
        return new HttpServerConfiguration.Builder().setHost("localhost").setPort(this.redirectPort.getNumber()).setName("redirect-client-test-server");
    }

    protected abstract HttpResponse setUpHttpRedirectResponse(HttpRequest var1);

    protected RequestHandler getRedirectRequestHandler() {
        return (requestContext, responseCallback) -> responseCallback.responseReady(this.setUpHttpRedirectResponse(requestContext.getRequest()), (ResponseStatusCallback)new AbstractHttpServiceTestCase.IgnoreResponseStatusCallback());
    }

    protected String getRedirectUri() {
        return "http://localhost:" + this.redirectPort.getValue();
    }

    @Override
    @After
    public void tearDown() throws Exception {
        if (this.redirectServer != null) {
            this.redirectServer.stop();
            this.redirectServer.dispose();
        }
    }
}

