/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.http.impl.service.server.grizzly;

import java.io.IOException;
import javax.net.ssl.SSLHandshakeException;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSession;
import org.glassfish.grizzly.filterchain.FilterChainContext;
import org.glassfish.grizzly.filterchain.NextAction;
import org.glassfish.grizzly.ssl.SSLConnectionContext;
import org.glassfish.grizzly.ssl.SSLEngineConfigurator;
import org.glassfish.grizzly.ssl.SSLFilter;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.tls.TlsContextFactory;
import org.mule.runtime.http.api.HttpConstants;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MuleSslFilter
extends SSLFilter {
    public static final String SSL_SESSION_ATTRIBUTE_KEY = "muleSslSession";
    private static final Logger logger = LoggerFactory.getLogger(MuleSslFilter.class);

    public MuleSslFilter(SSLEngineConfigurator serverSSLEngineConfigurator, SSLEngineConfigurator clientSSLEngineConfigurator) {
        super(serverSSLEngineConfigurator, clientSSLEngineConfigurator);
    }

    public NextAction handleRead(FilterChainContext ctx) throws IOException {
        try {
            ctx.getAttributes().setAttribute(HttpConstants.Protocol.HTTPS.getScheme(), (Object)true);
            NextAction nextAction = super.handleRead(ctx);
            ctx.getAttributes().setAttribute(SSL_SESSION_ATTRIBUTE_KEY, (Object)this.getSslSession(ctx));
            return nextAction;
        }
        catch (SSLHandshakeException e) {
            logger.error("SSL handshake error: " + e.getMessage());
            throw e;
        }
    }

    private SSLSession getSslSession(FilterChainContext ctx) throws SSLPeerUnverifiedException {
        SSLConnectionContext sslConnectionContext = this.obtainSslConnectionContext(ctx.getConnection());
        if (sslConnectionContext == null) {
            return null;
        }
        return sslConnectionContext.getSslEngine().getSession();
    }

    protected static MuleSslFilter createSslFilter(TlsContextFactory tlsContextFactory) {
        try {
            String[] enabledCipherSuites;
            boolean clientAuth = tlsContextFactory.isTrustStoreConfigured();
            SSLEngineConfigurator serverConfig = new SSLEngineConfigurator(tlsContextFactory.createSslContext(), false, clientAuth, false);
            String[] enabledProtocols = tlsContextFactory.getEnabledProtocols();
            if (enabledProtocols != null) {
                serverConfig.setEnabledProtocols(enabledProtocols);
            }
            if ((enabledCipherSuites = tlsContextFactory.getEnabledCipherSuites()) != null) {
                serverConfig.setEnabledCipherSuites(enabledCipherSuites);
            }
            SSLEngineConfigurator clientConfig = serverConfig.copy().setClientMode(true);
            return new MuleSslFilter(serverConfig, clientConfig);
        }
        catch (Exception e) {
            throw new MuleRuntimeException((Throwable)e);
        }
    }
}

