/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.http.impl.functional;

import java.lang.reflect.Field;
import java.util.Optional;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.mockito.Mockito;
import org.mule.runtime.api.artifact.Registry;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.config.MuleConfiguration;
import org.mule.runtime.core.api.config.bootstrap.ArtifactType;
import org.mule.runtime.http.api.server.HttpServerConfiguration;
import org.mule.runtime.http.api.server.HttpServerFactory;
import org.mule.runtime.http.api.server.ServerNotFoundException;
import org.mule.service.http.impl.functional.AbstractHttpServiceTestCase;
import org.mule.service.http.impl.service.server.ContextHttpServerFactoryAdapter;

public class HttpServiceImplementationServerFactoryTestCase
extends AbstractHttpServiceTestCase {
    private static final HttpServerConfiguration serverConfiguration = new HttpServerConfiguration.Builder().setName("CONFIG_NAME").setHost("localhost").setPort(8081).build();
    private static final String MULE_CONTEXT_ID = "muleContextId";
    private static final Field serverFactoryContextField;
    private static final Field serverFactoryParentContextField;
    @Rule
    public ExpectedException expectedException = ExpectedException.none();

    public HttpServiceImplementationServerFactoryTestCase(String serviceToLoad) {
        super(serviceToLoad);
    }

    @Test
    public void unknownArtifactTypeFallbackToOldBehaviour() throws Exception {
        HttpServerFactory httpServerFactory = this.newServerFactory(Optional.empty(), Optional.empty(), ArtifactType.PLUGIN);
        this.assertServerFactory(httpServerFactory, MULE_CONTEXT_ID, Optional.empty());
        MatcherAssert.assertThat((Object)httpServerFactory.create(serverConfiguration), (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
    }

    @Test
    public void appWithNoNameFallbackToOldBehaviour() throws Exception {
        HttpServerFactory httpServerFactory = this.newServerFactory(Optional.empty(), Optional.empty(), ArtifactType.APP);
        this.assertServerFactory(httpServerFactory, MULE_CONTEXT_ID, Optional.empty());
        MatcherAssert.assertThat((Object)httpServerFactory.create(serverConfiguration), (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
    }

    @Test
    public void domainWithNoNameFallbackToOldBehaviour() throws Exception {
        HttpServerFactory httpServerFactory = this.newServerFactory(Optional.empty(), Optional.empty(), ArtifactType.DOMAIN);
        this.assertServerFactory(httpServerFactory, MULE_CONTEXT_ID, Optional.empty());
        MatcherAssert.assertThat((Object)httpServerFactory.create(serverConfiguration), (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
    }

    @Test
    public void policyWithNoNameFallbackToOldBehaviour() throws Exception {
        HttpServerFactory httpServerFactory = this.newServerFactory(Optional.empty(), Optional.empty(), ArtifactType.POLICY);
        this.assertServerFactory(httpServerFactory, MULE_CONTEXT_ID, Optional.empty());
        MatcherAssert.assertThat((Object)httpServerFactory.create(serverConfiguration), (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
    }

    @Test
    public void sameAppAccessSameServer() throws Exception {
        String app = "app";
        HttpServerFactory factory = this.newAppServerFactory("app", Optional.empty());
        MatcherAssert.assertThat((Object)factory.create(serverConfiguration), (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        MatcherAssert.assertThat((Object)factory.lookup(serverConfiguration.getName()), (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
    }

    @Test
    public void sameDomainAccessSameServer() throws Exception {
        String domain = "domain";
        HttpServerFactory factory = this.newDomainServerFactory("domain");
        MatcherAssert.assertThat((Object)factory.create(serverConfiguration), (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        MatcherAssert.assertThat((Object)factory.lookup(serverConfiguration.getName()), (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
    }

    @Test
    public void samePolicyAccessSameServer() throws Exception {
        String policy = "policy";
        HttpServerFactory factory = this.newPolicyServerFactory("policy");
        MatcherAssert.assertThat((Object)factory.create(serverConfiguration), (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        MatcherAssert.assertThat((Object)factory.lookup(serverConfiguration.getName()), (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
    }

    @Test
    public void appsAccessServerFromDomain() throws Exception {
        String app1 = "app1";
        String app2 = "app2";
        String domain = "domain";
        HttpServerFactory appFactory1 = this.newAppServerFactory("app1", Optional.of("domain"));
        HttpServerFactory appFactory2 = this.newAppServerFactory("app2", Optional.of("domain"));
        HttpServerFactory domainFactory = this.newDomainServerFactory("domain");
        MatcherAssert.assertThat((Object)domainFactory.create(serverConfiguration), (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        MatcherAssert.assertThat((Object)appFactory1.lookup(serverConfiguration.getName()), (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        MatcherAssert.assertThat((Object)appFactory2.lookup(serverConfiguration.getName()), (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
    }

    @Test
    public void policyCantAccessAppServer() throws Exception {
        String policy = "policy";
        String app = "app";
        HttpServerFactory appFactory = this.newAppServerFactory("app", Optional.empty());
        HttpServerFactory policyFactory = this.newPolicyServerFactory("policy");
        MatcherAssert.assertThat((Object)appFactory.create(serverConfiguration), (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        this.expectedException.expect(ServerNotFoundException.class);
        policyFactory.lookup(serverConfiguration.getName());
    }

    @Test
    public void policyCantAccessAppServerWithSameNames() throws Exception {
        String name = "sameName";
        HttpServerFactory appFactory = this.newAppServerFactory("sameName", Optional.empty());
        HttpServerFactory policyFactory = this.newPolicyServerFactory("sameName");
        MatcherAssert.assertThat((Object)appFactory.create(serverConfiguration), (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        this.expectedException.expect(ServerNotFoundException.class);
        policyFactory.lookup(serverConfiguration.getName());
    }

    @Test
    public void appCantAccessDomainServerWithSameNames() throws Exception {
        String name = "sameName";
        HttpServerFactory appFactory = this.newAppServerFactory("sameName", Optional.empty());
        HttpServerFactory domainFactory = this.newDomainServerFactory("sameName");
        MatcherAssert.assertThat((Object)domainFactory.create(serverConfiguration), (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        this.expectedException.expect(ServerNotFoundException.class);
        appFactory.lookup(serverConfiguration.getName());
    }

    @Test
    public void differentAppsDontAccessSameServers() throws Exception {
        String app1 = "app1";
        String app2 = "app2";
        HttpServerFactory factory1 = this.newAppServerFactory("app1", Optional.empty());
        HttpServerFactory factory2 = this.newAppServerFactory("app2", Optional.empty());
        MatcherAssert.assertThat((Object)factory1.create(serverConfiguration), (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        this.expectedException.expect(ServerNotFoundException.class);
        factory2.lookup(serverConfiguration.getName());
    }

    private HttpServerFactory newAppServerFactory(String appName, Optional<String> domainName) {
        return this.newServerFactory(Optional.of(appName), domainName, ArtifactType.APP);
    }

    private HttpServerFactory newDomainServerFactory(String domainName) {
        return this.newServerFactory(Optional.empty(), Optional.of(domainName), ArtifactType.DOMAIN);
    }

    private HttpServerFactory newPolicyServerFactory(String policyName) {
        return this.newServerFactory(Optional.of(policyName), Optional.empty(), ArtifactType.POLICY);
    }

    private HttpServerFactory newServerFactory(Optional<String> artifactName, Optional<String> domainName, ArtifactType artifactType) {
        MuleConfiguration muleConfiguration = (MuleConfiguration)Mockito.mock(MuleConfiguration.class);
        Mockito.when((Object)muleConfiguration.getShutdownTimeout()).thenReturn((Object)20L);
        MuleContext muleContext = (MuleContext)Mockito.mock(MuleContext.class);
        Mockito.when((Object)muleContext.getArtifactType()).thenReturn((Object)artifactType);
        Mockito.when((Object)muleContext.getConfiguration()).thenReturn((Object)muleConfiguration);
        Mockito.when((Object)muleContext.getId()).thenReturn((Object)MULE_CONTEXT_ID);
        Registry registry = (Registry)Mockito.mock(Registry.class);
        Mockito.when((Object)registry.lookupByName("app.name")).thenReturn(artifactName);
        Mockito.when((Object)registry.lookupByName("domain.name")).thenReturn(domainName);
        return this.service.getServerFactory(registry, muleContext);
    }

    private void assertServerFactory(HttpServerFactory serverFactory, String contextName, Optional<String> parentContext) throws Exception {
        MatcherAssert.assertThat((Object)serverFactoryContextField.get(serverFactory), (Matcher)Matchers.is((Object)contextName));
        MatcherAssert.assertThat((Object)serverFactoryParentContextField.get(serverFactory), (Matcher)Matchers.is(parentContext));
    }

    static {
        try {
            serverFactoryContextField = ContextHttpServerFactoryAdapter.class.getDeclaredField("context");
            serverFactoryContextField.setAccessible(true);
            serverFactoryParentContextField = ContextHttpServerFactoryAdapter.class.getDeclaredField("parentContext");
            serverFactoryParentContextField.setAccessible(true);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

