/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.http.impl.functional.client;

import java.io.InputStream;
import org.mule.runtime.http.api.HttpConstants;
import org.mule.runtime.http.api.client.HttpRequestOptions;
import org.mule.runtime.http.api.client.auth.HttpAuthentication;
import org.mule.runtime.http.api.domain.entity.HttpEntity;
import org.mule.runtime.http.api.domain.entity.InputStreamHttpEntity;
import org.mule.runtime.http.api.domain.message.request.HttpRequest;
import org.mule.runtime.http.api.domain.message.request.HttpRequestBuilder;
import org.mule.runtime.http.api.domain.message.response.HttpResponse;
import org.mule.runtime.http.api.domain.message.response.HttpResponseBuilder;
import org.mule.service.http.impl.functional.client.HttpClientPostStreamingTestCase;

public abstract class AbstractNtlmHttpClientPostStreamingTestCase
extends HttpClientPostStreamingTestCase {
    private static final String HEADER_AUTHORIZATION_NAME = "authorization";
    private static final String USERNAME = "Zaphod";
    private static final String PASSWORD = "Beeblebrox";
    private static final String DOMAIN = "Ursa-Minor";
    private static final String NTLM_HEADER = "NTLM";
    private static final String WWW_AUTHENTICATE = "WWW-Authenticate";
    private static final String NTLM_CORRECT_CHALLENGE_RESPONSE = "NTLM TlRMTVNTUAADAAAAGAAYAEgAAAAYABgAYAAAABQAFAB4AAAADAAMAIwAAAAaABoAmAAAAAAAAACyAAAAAYIAAgUBKAoAAAAPrYfKbe/jRoW5xDxHeoxC1gBmfWiS5+iX4OAN4xBKG/IFPwfH3agtPEia6YnhsADTVQBSAFMAQQAtAE0ASQBOAE8AUgBaAGEAcABoAG8AZABCAEEALQBGAEcATwBOAFoAQQAtAE8AUwBYAA==";
    private static final String NTLM_CHALLENGE = "NTLM TlRMTVNTUAACAAAAAAAAACgAAAABggAAU3J2Tm9uY2UAAAAAAAAAAA==";
    private static final String NTLM_MSG1 = "NTLM TlRMTVNTUAABAAAAAYIIogAAAAAoAAAAAAAAACgAAAAFASgKAAAADw==";

    public AbstractNtlmHttpClientPostStreamingTestCase(String serviceToLoad) {
        super(serviceToLoad);
    }

    @Override
    public HttpResponse doSetUpHttpResponse(HttpRequest request) {
        HttpResponseBuilder response = HttpResponse.builder();
        String authorization = request.getHeaderValue(HEADER_AUTHORIZATION_NAME);
        if (authorization == null) {
            response.statusCode(Integer.valueOf(HttpConstants.HttpStatus.UNAUTHORIZED.getStatusCode()));
            response.addHeader(WWW_AUTHENTICATE, NTLM_HEADER);
        } else if (authorization.equals(NTLM_MSG1)) {
            response.statusCode(Integer.valueOf(HttpConstants.HttpStatus.UNAUTHORIZED.getStatusCode()));
            response.addHeader(WWW_AUTHENTICATE, NTLM_CHALLENGE);
        } else if (authorization.equals(NTLM_CORRECT_CHALLENGE_RESPONSE)) {
            this.extractPayload(request);
            response.statusCode(Integer.valueOf(HttpConstants.HttpStatus.OK.getStatusCode()));
        } else {
            this.extractPayload(request);
            response.statusCode(Integer.valueOf(HttpConstants.HttpStatus.UNAUTHORIZED.getStatusCode()));
        }
        return response.build();
    }

    @Override
    public HttpRequestOptions getOptions() {
        HttpAuthentication.HttpNtlmAuthentication authentication = HttpAuthentication.HttpNtlmAuthentication.builder().username(USERNAME).password(PASSWORD).domain(DOMAIN).build();
        return HttpRequestOptions.builder().responseTimeout(3000).authentication((HttpAuthentication)authentication).build();
    }

    @Override
    public HttpRequest getRequest() {
        return ((HttpRequestBuilder)HttpRequest.builder().method(HttpConstants.Method.POST).uri(this.getUri()).entity((HttpEntity)new InputStreamHttpEntity(this.getInputStream()))).build();
    }

    protected abstract InputStream getInputStream();
}

