/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.http.impl.functional.client;

import com.ning.http.client.AsyncHttpClientConfigDefaults;
import io.qameta.allure.Story;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.mule.runtime.http.api.HttpConstants;
import org.mule.runtime.http.api.client.HttpClient;
import org.mule.runtime.http.api.client.HttpClientConfiguration;
import org.mule.runtime.http.api.domain.message.request.HttpRequest;
import org.mule.runtime.http.api.domain.message.response.HttpResponse;
import org.mule.service.http.impl.functional.client.AbstractHttpClientTestCase;
import org.mule.tck.http.TestProxyServer;
import org.mule.tck.junit4.rule.DynamicPort;
import org.mule.tck.junit4.rule.SystemProperty;

@Story(value="Proxies")
public class HttpClientProxyPropertiesTestCase
extends AbstractHttpClientTestCase {
    @Rule
    public DynamicPort proxyPort = new DynamicPort("proxyPort");
    @Rule
    public SystemProperty useProxyProperties = new SystemProperty(AsyncHttpClientConfigDefaults.ASYNC_CLIENT + "useProxyProperties", "true");
    @Rule
    public SystemProperty proxyHostProperty = new SystemProperty("http.proxyHost", "localhost");
    @Rule
    public SystemProperty proxyPortProperty = new SystemProperty("http.proxyPort", this.proxyPort.getValue());
    private TestProxyServer proxyServer = new TestProxyServer(this.proxyPort.getNumber(), this.port.getNumber(), false);
    private HttpClient client;

    public HttpClientProxyPropertiesTestCase(String serviceToLoad) {
        super(serviceToLoad);
    }

    @Override
    protected HttpResponse setUpHttpResponse(HttpRequest request) {
        return HttpResponse.builder().statusCode(Integer.valueOf(HttpConstants.HttpStatus.OK.getStatusCode())).build();
    }

    @Before
    public void createClient() throws Exception {
        this.proxyServer.start();
        this.client = this.service.getClientFactory().create(new HttpClientConfiguration.Builder().setName("proxy-properties-test").build());
        this.client.start();
    }

    @Test
    public void usesProxyWithoutExplicitConfig() throws Exception {
        HttpResponse response = this.client.send(HttpRequest.builder().uri(this.getUri()).build(), this.getDefaultOptions(10000));
        Assert.assertThat((Object)this.proxyServer.hasConnections(), (Matcher)Matchers.is((Object)true));
        Assert.assertThat((Object)response.getStatusCode(), (Matcher)Matchers.is((Object)HttpConstants.HttpStatus.OK.getStatusCode()));
    }

    @After
    public void stopClient() throws Exception {
        if (this.proxyServer != null) {
            this.proxyServer.stop();
        }
        if (this.client != null) {
            this.client.stop();
        }
    }
}

