/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.http.impl.functional.client;

import io.qameta.allure.Story;
import java.io.InputStream;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.mule.runtime.core.api.util.IOUtils;
import org.mule.runtime.http.api.HttpConstants;
import org.mule.runtime.http.api.client.HttpClient;
import org.mule.runtime.http.api.client.HttpClientConfiguration;
import org.mule.runtime.http.api.client.HttpRequestOptions;
import org.mule.runtime.http.api.client.proxy.ProxyConfig;
import org.mule.runtime.http.api.client.proxy.ProxyConfigBuilder;
import org.mule.runtime.http.api.domain.entity.ByteArrayHttpEntity;
import org.mule.runtime.http.api.domain.entity.HttpEntity;
import org.mule.runtime.http.api.domain.message.request.HttpRequest;
import org.mule.runtime.http.api.domain.message.response.HttpResponse;
import org.mule.runtime.http.api.domain.message.response.HttpResponseBuilder;
import org.mule.runtime.http.api.server.HttpServer;
import org.mule.runtime.http.api.server.HttpServerConfiguration;
import org.mule.runtime.http.api.server.async.ResponseStatusCallback;
import org.mule.service.http.impl.functional.AbstractHttpServiceTestCase;
import org.mule.service.http.impl.functional.client.AbstractHttpClientTestCase;
import org.mule.tck.http.TestProxyServer;
import org.mule.tck.junit4.rule.DynamicPort;

@Story(value="Proxies")
public class HttpClientProxyTestCase
extends AbstractHttpClientTestCase {
    private static final String GLOBAL_RESPONSE = "Global proxy used";
    private static final String REQUEST_RESPONSE = "Request proxy used";
    @Rule
    public DynamicPort globalProxyPort = new DynamicPort("globalProxyPort");
    @Rule
    public DynamicPort requestProxyPort = new DynamicPort("requestProxyPort");
    @Rule
    public DynamicPort serverPort = new DynamicPort("serverPort");
    private TestProxyServer globalProxy = new TestProxyServer(this.globalProxyPort.getNumber(), this.port.getNumber(), false);
    private TestProxyServer requestProxy = new TestProxyServer(this.requestProxyPort.getNumber(), this.serverPort.getNumber(), false);
    private HttpClient client;
    private HttpServer requestServer;

    public HttpClientProxyTestCase(String serviceToLoad) {
        super(serviceToLoad);
    }

    @Override
    protected HttpResponse setUpHttpResponse(HttpRequest request) {
        return ((HttpResponseBuilder)HttpResponse.builder().entity((HttpEntity)new ByteArrayHttpEntity(GLOBAL_RESPONSE.getBytes()))).build();
    }

    @Before
    public void createClient() throws Exception {
        this.requestServer = this.service.getServerFactory().create(new HttpServerConfiguration.Builder().setHost("localhost").setPort(this.serverPort.getNumber()).setName("proxy-test-server").build());
        this.requestServer.start();
        this.requestServer.addRequestHandler("/*", (requestContext, responseCallback) -> responseCallback.responseReady(((HttpResponseBuilder)HttpResponse.builder().entity((HttpEntity)new ByteArrayHttpEntity(REQUEST_RESPONSE.getBytes()))).build(), (ResponseStatusCallback)new AbstractHttpServiceTestCase.IgnoreResponseStatusCallback()));
        this.globalProxy.start();
        this.requestProxy.start();
        this.client = this.service.getClientFactory().create(new HttpClientConfiguration.Builder().setName("proxy-test").setProxyConfig(((ProxyConfigBuilder)((ProxyConfigBuilder)ProxyConfig.builder().host("localhost")).port(this.globalProxyPort.getNumber())).build()).build());
        this.client.start();
    }

    @After
    public void stopClient() throws Exception {
        if (this.requestServer != null) {
            this.requestServer.stop();
        }
        if (this.requestProxy != null) {
            this.requestProxy.stop();
        }
        if (this.globalProxy != null) {
            this.globalProxy.stop();
        }
        if (this.client != null) {
            this.client.stop();
        }
    }

    @Test
    public void usesDefaultProxy() throws Exception {
        HttpResponse response = this.client.send(HttpRequest.builder().uri(this.getUri()).build(), this.getDefaultOptions(10000));
        Assert.assertThat((Object)this.globalProxy.hasConnections(), (Matcher)Matchers.is((Object)true));
        Assert.assertThat((Object)this.requestProxy.hasConnections(), (Matcher)Matchers.is((Object)false));
        Assert.assertThat((Object)response.getStatusCode(), (Matcher)Matchers.is((Object)HttpConstants.HttpStatus.OK.getStatusCode()));
        Assert.assertThat((Object)IOUtils.toString((InputStream)response.getEntity().getContent()), (Matcher)Matchers.is((Object)GLOBAL_RESPONSE));
    }

    @Test
    public void overridesDefaultProxy() throws Exception {
        HttpResponse response = this.client.send(HttpRequest.builder().uri("http://localhost:" + this.serverPort.getValue()).build(), HttpRequestOptions.builder().responseTimeout(10000).proxyConfig(((ProxyConfigBuilder)((ProxyConfigBuilder)ProxyConfig.builder().host("localhost")).port(this.requestProxyPort.getNumber())).build()).build());
        Assert.assertThat((Object)this.globalProxy.hasConnections(), (Matcher)Matchers.is((Object)false));
        Assert.assertThat((Object)this.requestProxy.hasConnections(), (Matcher)Matchers.is((Object)true));
        Assert.assertThat((Object)response.getStatusCode(), (Matcher)Matchers.is((Object)HttpConstants.HttpStatus.OK.getStatusCode()));
        Assert.assertThat((Object)IOUtils.toString((InputStream)response.getEntity().getContent()), (Matcher)Matchers.is((Object)REQUEST_RESPONSE));
    }
}

