/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.http.impl.functional.client;

import java.util.ArrayList;
import java.util.List;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mule.runtime.api.lifecycle.CreateException;
import org.mule.runtime.http.api.HttpConstants;
import org.mule.runtime.http.api.client.HttpClient;
import org.mule.runtime.http.api.client.HttpClientConfiguration;
import org.mule.runtime.http.api.domain.message.request.HttpRequest;
import org.mule.runtime.http.api.domain.message.response.HttpResponse;
import org.mule.service.http.impl.functional.client.AbstractHttpClientTestCase;

public class HttpRequesterQuickConnectionCloseTestCase
extends AbstractHttpClientTestCase {
    private static int NUMBER_OF_REQUESTS = 50;
    private HttpClient client;
    private List<HttpResponse> responses = new ArrayList<HttpResponse>(NUMBER_OF_REQUESTS);
    private List<Throwable> errors = new ArrayList<Throwable>(NUMBER_OF_REQUESTS);

    public HttpRequesterQuickConnectionCloseTestCase(String serviceToLoad) {
        super(serviceToLoad);
    }

    @Before
    public void createClient() throws CreateException {
        this.client = this.service.getClientFactory().create(new HttpClientConfiguration.Builder().setMaxConnections(1).setName("http-requester-quick-connection-close").build());
        this.client.start();
    }

    @After
    public void stopClient() {
        if (this.client != null) {
            this.client.stop();
        }
    }

    @Test
    public void test() {
        for (int i = 0; i < NUMBER_OF_REQUESTS; ++i) {
            try {
                HttpResponse response = this.client.send(this.getRequest());
                this.responses.add(response);
                continue;
            }
            catch (Throwable e) {
                this.errors.add(e);
            }
        }
        Assert.assertThat((Object)this.responses.size(), (Matcher)Is.is((Object)NUMBER_OF_REQUESTS));
        Assert.assertThat((Object)this.errors.size(), (Matcher)Is.is((Object)0));
    }

    @Override
    protected HttpResponse setUpHttpResponse(HttpRequest request) {
        return HttpResponse.builder().statusCode(Integer.valueOf(HttpConstants.HttpStatus.OK.getStatusCode())).reasonPhrase(HttpConstants.HttpStatus.OK.getReasonPhrase()).build();
    }

    private HttpRequest getRequest() {
        return HttpRequest.builder().uri(this.getUri()).build();
    }
}

