/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.http.impl.functional.server;

import java.io.IOException;
import java.lang.ref.PhantomReference;
import java.lang.ref.ReferenceQueue;
import java.net.Socket;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.mule.runtime.http.api.server.HttpServer;
import org.mule.runtime.http.api.server.HttpServerConfiguration;
import org.mule.runtime.http.api.server.ServerCreationException;
import org.mule.service.http.impl.functional.AbstractHttpServiceTestCase;
import org.mule.tck.junit4.rule.DynamicPort;
import org.mule.tck.probe.PollingProber;

public class HttpServerLeakTestCase
extends AbstractHttpServiceTestCase {
    private static final int GC_POLLING_TIMEOUT = 10000;
    @Rule
    public DynamicPort port = new DynamicPort("port");

    public HttpServerLeakTestCase(String serviceToLoad) {
        super(serviceToLoad);
    }

    @Test
    public void theServerIsNotLeakedEvenAfterReceiveAConnection() throws ServerCreationException, IOException {
        HttpServer server = this.service.getServerFactory().create(new HttpServerConfiguration.Builder().setHost("localhost").setPort(this.port.getNumber()).setName("NoLeakServer").build());
        PhantomReference<HttpServer> serverRef = new PhantomReference<HttpServer>(server, new ReferenceQueue());
        server.start();
        Socket clientSocket = new Socket("localhost", this.port.getNumber());
        clientSocket.close();
        server.stop();
        server.dispose();
        server = null;
        PollingProber.probe((long)10000L, (long)100L, () -> {
            System.gc();
            Assert.assertThat((Object)serverRef.isEnqueued(), (Matcher)Matchers.is((Object)true));
            return true;
        });
    }
}

