/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.soap.security;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Optional;
import org.mule.runtime.extension.api.soap.security.config.WssKeyStoreConfiguration;
import org.mule.service.soap.security.SecurityStrategyCxfAdapter;
import org.mule.service.soap.security.SecurityStrategyType;
import org.mule.service.soap.security.callback.WSPasswordCallbackHandler;
import org.mule.service.soap.security.config.WssKeyStoreConfigurationPropertiesBuilder;

public class WssSignSecurityStrategyCxfAdapter
implements SecurityStrategyCxfAdapter {
    private static final String WS_SIGN_PROPERTIES_KEY = "signProperties";
    private final WssKeyStoreConfigurationPropertiesBuilder keyStoreConfiguration;

    public WssSignSecurityStrategyCxfAdapter(WssKeyStoreConfiguration keyStoreConfiguration) {
        this.keyStoreConfiguration = new WssKeyStoreConfigurationPropertiesBuilder(keyStoreConfiguration);
    }

    @Override
    public SecurityStrategyType securityType() {
        return SecurityStrategyType.OUTGOING;
    }

    @Override
    public Optional<WSPasswordCallbackHandler> buildPasswordCallbackHandler() {
        return Optional.of(new WSPasswordCallbackHandler(3, cb -> cb.setPassword(this.keyStoreConfiguration.getPassword())));
    }

    @Override
    public String securityAction() {
        return "Signature";
    }

    @Override
    public Map<String, Object> buildSecurityProperties() {
        return ImmutableMap.builder().put((Object)"signaturePropRefId", (Object)WS_SIGN_PROPERTIES_KEY).put((Object)WS_SIGN_PROPERTIES_KEY, (Object)this.keyStoreConfiguration.getConfigurationProperties()).put((Object)"signatureUser", (Object)this.keyStoreConfiguration.getAlias()).build();
    }
}

