/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.soap.generator;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.wsdl.Message;
import javax.wsdl.Part;
import javax.xml.namespace.QName;
import org.mule.metadata.api.TypeLoader;
import org.mule.metadata.api.model.MetadataType;
import org.mule.runtime.soap.api.exception.BadRequestException;
import org.mule.service.soap.util.SoapServiceMetadataTypeUtils;
import org.mule.wsdl.parser.model.PortModel;
import org.mule.wsdl.parser.model.operation.OperationModel;

final class EmptyRequestGenerator {
    private static final String REQUIRED_PARAMS_ERROR_MASK = "Cannot build default body request for operation [%s]%s, the operation requires input parameters";
    private static final String NO_PARAMS_SOAP_BODY_CALL_MASK = "<ns:%s xmlns:ns=\"%s\"/>";
    private final PortModel port;
    private final TypeLoader loader;

    public EmptyRequestGenerator(PortModel port, TypeLoader loader) {
        this.port = port;
        this.loader = loader;
    }

    String generateRequest(String operationName) {
        OperationModel operation = this.port.getOperation(operationName);
        Optional<Part> part = this.getSinglePart(operation.getInputParts(), operation.getInputMessage());
        if (!part.isPresent()) {
            throw new BadRequestException(String.format(REQUIRED_PARAMS_ERROR_MASK, operationName, " there is no single part in the input message"));
        }
        if (part.get().getElementName() == null) {
            throw new BadRequestException(String.format(REQUIRED_PARAMS_ERROR_MASK, operationName, " there is one message body part but no does not have an element defined"));
        }
        Part bodyPart = part.get();
        if (this.isOperationWithRequiredParameters(this.loader, bodyPart)) {
            throw new BadRequestException(String.format(REQUIRED_PARAMS_ERROR_MASK, operationName, ""));
        }
        QName element = bodyPart.getElementName();
        return String.format(NO_PARAMS_SOAP_BODY_CALL_MASK, element.getLocalPart(), element.getNamespaceURI());
    }

    private boolean isOperationWithRequiredParameters(TypeLoader loader, Part part) {
        Optional bodyType = loader.load(part.getElementName().toString());
        if (bodyType.isPresent()) {
            Collection operationFields = SoapServiceMetadataTypeUtils.getOperationType((MetadataType)bodyType.get()).getFields();
            return !operationFields.isEmpty();
        }
        return false;
    }

    private Optional<Part> getSinglePart(List<String> soapBodyParts, Message inputMessage) {
        if (soapBodyParts.isEmpty()) {
            Map parts = inputMessage.getParts();
            if (parts.size() == 1) {
                return Optional.ofNullable((Part)parts.values().iterator().next());
            }
        } else if (soapBodyParts.size() == 1) {
            String partName = soapBodyParts.get(0);
            return Optional.ofNullable(inputMessage.getPart(partName));
        }
        return Optional.empty();
    }
}

