/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.soap;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.cxf.interceptor.Interceptor;
import org.custommonkey.xmlunit.XMLUnit;
import org.junit.After;
import org.junit.Before;
import org.junit.Rule;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.mule.runtime.extension.api.soap.message.MessageDispatcher;
import org.mule.runtime.extension.api.soap.security.SecurityStrategy;
import org.mule.runtime.soap.api.SoapVersion;
import org.mule.service.soap.SoapTestXmlValues;
import org.mule.service.soap.client.DefaultTestDispatcher;
import org.mule.service.soap.client.TestSoapClient;
import org.mule.service.soap.server.HttpServer;
import org.mule.service.soap.service.Soap11Service;
import org.mule.service.soap.service.Soap12Service;
import org.mule.tck.junit4.rule.DynamicPort;

@RunWith(value=Parameterized.class)
public abstract class AbstractSoapServiceTestCase {
    public final SoapTestXmlValues testValues = new SoapTestXmlValues("http://service.soap.service.mule.org/");
    public final DefaultTestDispatcher dispatcher = new DefaultTestDispatcher();
    @Rule
    public DynamicPort port = new DynamicPort("port");
    @Parameterized.Parameter
    public SoapVersion soapVersion;
    @Parameterized.Parameter(value=1)
    public String serviceClass;
    protected TestSoapClient client;
    protected HttpServer server;

    @Parameterized.Parameters(name="{0}")
    public static Collection<Object[]> data() {
        return Arrays.asList({SoapVersion.SOAP11, Soap11Service.class.getName()}, {SoapVersion.SOAP12, Soap12Service.class.getName()});
    }

    @Before
    public void before() throws Exception {
        XMLUnit.setIgnoreWhitespace((boolean)true);
        this.server = new HttpServer(this.port.getNumber(), this.buildInInterceptor(), this.buildOutInterceptor(), this.createServiceInstance());
        this.client = new TestSoapClient(TestSoapClient.getDefaultConfiguration(this.server.getDefaultAddress()).enableMtom(this.isMtom()).withVersion(this.soapVersion).withDispatcher((MessageDispatcher)this.dispatcher).withSecurities(this.getSecurityStrategies()).build());
    }

    protected boolean isMtom() {
        return false;
    }

    @After
    public void tearDown() throws Exception {
        this.client.stop();
        this.dispatcher.stop();
    }

    protected List<SecurityStrategy> getSecurityStrategies() {
        return Collections.emptyList();
    }

    protected String getServiceClass() {
        return this.serviceClass;
    }

    protected Interceptor buildInInterceptor() {
        return null;
    }

    protected Interceptor buildOutInterceptor() {
        return null;
    }

    private Object createServiceInstance() throws Exception {
        Class<?> serviceClass = this.getClass().getClassLoader().loadClass(this.getServiceClass());
        return serviceClass.newInstance();
    }
}

