/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.soap.runtime;

import io.qameta.allure.Description;
import io.qameta.allure.Feature;
import io.qameta.allure.Story;
import java.net.URL;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.mockito.Mockito;
import org.mule.runtime.api.connection.ConnectionException;
import org.mule.runtime.extension.api.soap.message.MessageDispatcher;
import org.mule.runtime.soap.api.client.SoapClientConfiguration;
import org.mule.runtime.soap.api.client.SoapClientFactory;
import org.mule.service.soap.AbstractSoapServiceTestCase;
import org.mule.service.soap.SoapServiceImplementation;

@Feature(value="WSC Extension")
@Story(value="Connection")
public class SoapClientFactoryTestCase
extends AbstractSoapServiceTestCase {
    @Rule
    public ExpectedException expectedException = ExpectedException.none();
    private SoapClientFactory factory = new SoapServiceImplementation().getClientFactory();

    @Test
    @Description(value="Tries to instantiate a connection with an RPC WSDL and fails.")
    public void rpcWsdlFails() throws Exception {
        this.expectedException.expect(ConnectionException.class);
        this.expectedException.expectMessage("RPC WSDLs are not supported");
        URL resource = Thread.currentThread().getContextClassLoader().getResource("wsdl/rpc.wsdl");
        this.factory.create(SoapClientConfiguration.builder().withPort("SoapResponderPortType").withService("SoapResponder").withDispatcher((MessageDispatcher)Mockito.mock(MessageDispatcher.class)).withWsdlLocation(resource.getPath()).build());
    }

    @Test
    @Description(value="Tries to create a client with an invalid service")
    public void invalidService() throws Exception {
        this.expectedException.expect(ConnectionException.class);
        this.expectedException.expectMessage("Service [INVALID_SERVICE] is not defined in the wsdl");
        URL resource = Thread.currentThread().getContextClassLoader().getResource("wsdl/simple-service.wsdl");
        this.factory.create(SoapClientConfiguration.builder().withPort("INVALID PORT").withService("INVALID_SERVICE").withDispatcher((MessageDispatcher)Mockito.mock(MessageDispatcher.class)).withWsdlLocation(resource.getPath()).build());
    }

    @Test
    @Description(value="Tries to create a client with an invalid service")
    public void invalidPort() throws Exception {
        this.expectedException.expect(ConnectionException.class);
        this.expectedException.expectMessage("Port [INVALID PORT] not found in service [TestService]");
        URL resource = Thread.currentThread().getContextClassLoader().getResource("wsdl/simple-service.wsdl");
        this.factory.create(SoapClientConfiguration.builder().withPort("INVALID PORT").withService("TestService").withDispatcher((MessageDispatcher)Mockito.mock(MessageDispatcher.class)).withWsdlLocation(resource.getPath()).build());
    }
}

