/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.soap.unit;

import javax.xml.stream.XMLStreamReader;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.core.Is;
import org.junit.Test;
import org.mule.service.soap.util.XmlTransformationUtils;

public class XmlTransformationUtilsTestCase {
    @Test
    public void stringToXmlStreamReaderPreservesCDataElements() throws Exception {
        String cdataContent = "<xml>M4cr1<xml/>!#EWDSA!@#!@#@!";
        String data = "<data><![CDATA[" + cdataContent + "]]></data>";
        XMLStreamReader reader = XmlTransformationUtils.stringToXmlStreamReader((String)data);
        boolean foundCdata = false;
        int event = reader.next();
        while (reader.hasNext()) {
            switch (event) {
                case 12: {
                    foundCdata = true;
                }
            }
            event = reader.next();
        }
        MatcherAssert.assertThat((Object)foundCdata, (Matcher)Is.is((Object)true));
    }

    @Test
    public void stringToXmlStreamReader() throws Exception {
        String data = "<data><data2>Juani</data2></data>";
        XMLStreamReader reader = XmlTransformationUtils.stringToXmlStreamReader((String)data);
        int startTagCount = 0;
        int endTagCount = 0;
        String textFound = "";
        int event = reader.next();
        while (reader.hasNext()) {
            switch (event) {
                case 2: {
                    ++endTagCount;
                    break;
                }
                case 4: {
                    textFound = reader.getText();
                    break;
                }
                case 1: {
                    ++startTagCount;
                    break;
                }
            }
            event = reader.next();
        }
        MatcherAssert.assertThat((Object)startTagCount, (Matcher)Is.is((Object)2));
        MatcherAssert.assertThat((Object)textFound, (Matcher)Is.is((Object)"Juani"));
        MatcherAssert.assertThat((Object)endTagCount, (Matcher)Is.is((Object)2));
    }
}

