/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.soap.security;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Optional;
import org.mule.runtime.extension.api.soap.security.PasswordType;
import org.mule.runtime.extension.api.soap.security.UsernameTokenSecurityStrategy;
import org.mule.service.soap.security.SecurityStrategyCxfAdapter;
import org.mule.service.soap.security.SecurityStrategyType;
import org.mule.service.soap.security.callback.WSPasswordCallbackHandler;

public class WssUsernameTokenSecurityStrategyCxfAdapter
implements SecurityStrategyCxfAdapter {
    private String username;
    private String password;
    private PasswordType passwordType;
    private boolean addNonce;
    private boolean addCreated;

    public WssUsernameTokenSecurityStrategyCxfAdapter(UsernameTokenSecurityStrategy usernameToken) {
        this.addCreated = usernameToken.isAddCreated();
        this.addNonce = usernameToken.isAddNonce();
        this.password = usernameToken.getPassword();
        this.username = usernameToken.getUsername();
        this.passwordType = usernameToken.getPasswordType();
    }

    @Override
    public SecurityStrategyType securityType() {
        return SecurityStrategyType.OUTGOING;
    }

    @Override
    public Optional<WSPasswordCallbackHandler> buildPasswordCallbackHandler() {
        return Optional.of(new WSPasswordCallbackHandler(2, cb -> {
            if (cb.getIdentifier().equals(this.username)) {
                cb.setPassword(this.password);
            }
        }));
    }

    @Override
    public String securityAction() {
        return "UsernameToken";
    }

    @Override
    public Map<String, Object> buildSecurityProperties() {
        return ImmutableMap.builder().put((Object)"user", (Object)this.username).put((Object)"passwordType", (Object)this.passwordType.getType()).put((Object)"addUsernameTokenNonce", (Object)String.valueOf(this.addNonce)).put((Object)"addUsernameTokenCreated", (Object)String.valueOf(this.addNonce)).build();
    }
}

