/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.soap.client;

import org.junit.rules.ExternalResource;
import org.mule.runtime.api.connection.ConnectionException;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.soap.api.client.SoapClient;
import org.mule.runtime.soap.api.client.SoapClientConfiguration;
import org.mule.runtime.soap.api.client.SoapClientConfigurationBuilder;
import org.mule.runtime.soap.api.client.metadata.SoapMetadataResolver;
import org.mule.runtime.soap.api.message.SoapRequest;
import org.mule.runtime.soap.api.message.SoapResponse;
import org.mule.service.soap.SoapServiceImplementation;

public class TestSoapClient
extends ExternalResource
implements SoapClient {
    private static final String DEFAULT_TEST_SERVICE_NAME = "TestService";
    private static final String DEFAULT_TEST_PORT_NAME = "TestPort";
    private final SoapClient soapClient;

    public TestSoapClient(SoapClientConfiguration config) {
        this.soapClient = this.getClient(config);
    }

    private SoapClient getClient(SoapClientConfiguration config) {
        try {
            return new SoapServiceImplementation().getClientFactory().create(config);
        }
        catch (ConnectionException e) {
            throw new RuntimeException(e);
        }
    }

    public static SoapClientConfigurationBuilder getDefaultConfiguration(String address) {
        return SoapClientConfiguration.builder().withAddress(address).withWsdlLocation(address + "?wsdl").withService(DEFAULT_TEST_SERVICE_NAME).withPort(DEFAULT_TEST_PORT_NAME);
    }

    public SoapResponse consume(SoapRequest request) {
        return this.soapClient.consume(request);
    }

    public SoapMetadataResolver getMetadataResolver() {
        return this.soapClient.getMetadataResolver();
    }

    public void start() throws MuleException {
    }

    public void stop() throws MuleException {
    }
}

