/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.soap.metadata;

import io.qameta.allure.Description;
import io.qameta.allure.Feature;
import io.qameta.allure.Story;
import java.net.URL;
import java.util.Collection;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Test;
import org.mule.metadata.api.model.BinaryType;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.model.NullType;
import org.mule.metadata.api.model.ObjectFieldType;
import org.mule.metadata.api.model.ObjectType;
import org.mule.runtime.api.metadata.MetadataResolvingException;
import org.mule.runtime.extension.api.soap.message.MessageDispatcher;
import org.mule.runtime.soap.api.client.SoapClientConfiguration;
import org.mule.runtime.soap.api.client.metadata.SoapMetadataResolver;
import org.mule.runtime.soap.api.client.metadata.SoapOperationMetadata;
import org.mule.service.soap.client.TestSoapClient;
import org.mule.service.soap.metadata.AbstractMetadataTestCase;

@Feature(value="WSC Extension")
@Story(value="Metadata")
public class AttachmentMetadataTestCase
extends AbstractMetadataTestCase {
    @Test
    @Description(value="Checks the Input Metadata of an operation with required input attachments")
    public void operationWithInputAttachmentMetadata() throws MetadataResolvingException {
        SoapOperationMetadata result = this.resolver.getInputMetadata("uploadAttachment");
        ObjectType attachments = this.toObjectType(result.getAttachmentsType());
        Collection attachmentFields = attachments.getFields();
        MatcherAssert.assertThat((Object)attachmentFields, (Matcher)Matchers.hasSize((int)1));
        MatcherAssert.assertThat((Object)((ObjectFieldType)attachmentFields.iterator().next()).getKey().getName().getLocalPart(), (Matcher)Is.is((Object)"attachment"));
    }

    @Test
    @Description(value="Checks the Input Metadata of an operation without attachments")
    public void operationWithoutInputAttachmentsMetadata() throws MetadataResolvingException {
        SoapOperationMetadata result = this.resolver.getInputMetadata("echo");
        MatcherAssert.assertThat((Object)result.getAttachmentsType(), (Matcher)Is.is((Matcher)Matchers.instanceOf(NullType.class)));
    }

    @Test
    @Description(value="Checks the Output Metadata of an operation that contains output attachments")
    public void operationWithOutputAttachmentsMetadata() throws MetadataResolvingException {
        SoapOperationMetadata result = this.resolver.getOutputMetadata("downloadAttachment");
        ObjectType objectType = this.toObjectType(result.getAttachmentsType());
        MatcherAssert.assertThat((Object)objectType.getFields(), (Matcher)Matchers.hasSize((int)1));
        ObjectFieldType attachment = (ObjectFieldType)objectType.getFields().iterator().next();
        MatcherAssert.assertThat((Object)attachment.getKey().getName().getLocalPart(), (Matcher)Is.is((Object)"attachment"));
        MatcherAssert.assertThat((Object)attachment.getValue(), (Matcher)Is.is((Matcher)Matchers.instanceOf(BinaryType.class)));
        MatcherAssert.assertThat((Object)result.getBodyType(), (Matcher)Is.is((Matcher)Matchers.instanceOf(NullType.class)));
    }

    @Test
    @Description(value="Checks the metadata for a multipart related output with a body and attachment")
    public void multipartOutputOperation() throws MetadataResolvingException {
        URL wsdl = Thread.currentThread().getContextClassLoader().getResource("wsdl/multipart-output/Multipart.wsdl");
        SoapClientConfiguration configuration = SoapClientConfiguration.builder().withDispatcher((MessageDispatcher)this.dispatcher).withAddress("address.com").withVersion(this.soapVersion).withWsdlLocation(wsdl.getPath()).withService("MultipartService").withPort("MultipartPort").build();
        TestSoapClient client = new TestSoapClient(configuration);
        SoapMetadataResolver resolver = client.getMetadataResolver();
        SoapOperationMetadata result = resolver.getOutputMetadata("retrieveDocument");
        MetadataType attachmentsType = result.getAttachmentsType();
        MatcherAssert.assertThat((Object)this.toObjectType(attachmentsType).getFields().size(), (Matcher)Is.is((Object)1));
        MetadataType bodyType = result.getBodyType();
        Collection bodyFields = this.toObjectType(bodyType).getFields();
        MatcherAssert.assertThat((Object)bodyFields.size(), (Matcher)Is.is((Object)1));
        MatcherAssert.assertThat((Object)((ObjectFieldType)bodyFields.iterator().next()).getValue().toString(), (Matcher)Matchers.containsString((String)"AnonType_RetrieveDocumentResponse"));
    }

    @Test
    @Description(value="Checks the metadata for an operation that is ONE WAY")
    public void oneWayOperationMetadata() throws MetadataResolvingException {
        SoapOperationMetadata input = this.resolver.getInputMetadata("oneWay");
        SoapOperationMetadata output = this.resolver.getOutputMetadata("oneWay");
        Assert.assertThat((Object)input.getAttachmentsType(), (Matcher)Is.is((Matcher)Matchers.instanceOf(NullType.class)));
        Assert.assertThat((Object)output.getAttachmentsType(), (Matcher)Is.is((Matcher)Matchers.instanceOf(NullType.class)));
    }
}

