/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.soap.runtime;

import com.google.common.collect.ImmutableMap;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Map;
import org.hamcrest.Matcher;
import org.hamcrest.collection.IsCollectionWithSize;
import org.hamcrest.collection.IsMapContaining;
import org.junit.Assert;
import org.junit.Test;
import org.mule.runtime.extension.api.soap.message.DispatchingRequest;
import org.mule.runtime.extension.api.soap.message.DispatchingResponse;
import org.mule.runtime.extension.api.soap.message.MessageDispatcher;
import org.mule.runtime.soap.api.message.ImmutableSoapRequest;
import org.mule.runtime.soap.api.message.SoapRequest;
import org.mule.runtime.soap.api.message.SoapResponse;
import org.mule.service.soap.AbstractSoapServiceTestCase;
import org.mule.service.soap.SoapTestUtils;
import org.mule.service.soap.client.TestSoapClient;

public class CustomDispatcherTestCase
extends AbstractSoapServiceTestCase {
    private static final String RESPONSE = "<text>RESPONSE</text>";

    @Test
    public void customDispatcher() throws Exception {
        SoapResponse response = this.getTestClient().consume(SoapRequest.empty((String)"noParams"));
        SoapTestUtils.assertSimilarXml(RESPONSE, response.getContent());
    }

    @Test
    public void transportHeaders() {
        ImmutableSoapRequest request = SoapRequest.builder().operation("noParams").transportHeaders((Map)ImmutableMap.builder().put((Object)"H1", (Object)"H1Value").put((Object)"H2", (Object)"H2Value").build()).build();
        SoapResponse response = this.getTestClient().consume((SoapRequest)request);
        Map transportHeaders = response.getTransportHeaders();
        Assert.assertThat(transportHeaders.entrySet(), (Matcher)IsCollectionWithSize.hasSize((int)4));
        Assert.assertThat((Object)transportHeaders, (Matcher)IsMapContaining.hasEntry((Object)"H1", (Object)"H1Value"));
        Assert.assertThat((Object)transportHeaders, (Matcher)IsMapContaining.hasEntry((Object)"H2", (Object)"H2Value"));
    }

    private TestSoapClient getTestClient() {
        return new TestSoapClient(TestSoapClient.getDefaultConfiguration(this.server.getDefaultAddress()).withVersion(this.soapVersion).withDispatcher((MessageDispatcher)new TestDispatcher()).build());
    }

    public class TestDispatcher
    implements MessageDispatcher {
        public DispatchingResponse dispatch(DispatchingRequest request) {
            String envelope = "<s:Envelope xmlns:s=\"http://schemas.xmlsoap.org/soap/envelope/\"><s:Body><text>RESPONSE</text></s:Body></s:Envelope>";
            return new DispatchingResponse((InputStream)new ByteArrayInputStream(envelope.getBytes()), request.getHeaders());
        }
    }
}

