/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.soap.runtime.wss;

import io.qameta.allure.Feature;
import io.qameta.allure.Story;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import org.apache.cxf.interceptor.Interceptor;
import org.apache.cxf.ws.security.wss4j.WSS4JInInterceptor;
import org.apache.wss4j.common.crypto.Merlin;
import org.mule.runtime.extension.api.soap.security.EncryptSecurityStrategy;
import org.mule.runtime.extension.api.soap.security.SecurityStrategy;
import org.mule.runtime.extension.api.soap.security.config.WssKeyStoreConfiguration;
import org.mule.service.soap.runtime.wss.AbstractWebServiceSecurityTestCase;
import org.mule.service.soap.service.EncryptPasswordCallback;

@Feature(value="WSC Extension")
@Story(value="WSS")
public class WssEncryptTestCase
extends AbstractWebServiceSecurityTestCase {
    @Override
    protected Interceptor buildInInterceptor() {
        HashMap<String, Object> props = new HashMap<String, Object>();
        props.put("action", "Encrypt");
        props.put("passwordCallbackClass", EncryptPasswordCallback.class.getName());
        String decryptionPropRefId = "securityProperties";
        props.put("decryptionPropRefId", "securityProperties");
        Properties securityProperties = new Properties();
        securityProperties.put("org.apache.ws.security.crypto.provider", Merlin.class.getName());
        securityProperties.put("org.apache.ws.security.crypto.merlin.keystore.type", "jks");
        securityProperties.put("org.apache.ws.security.crypto.merlin.keystore.password", "changeit");
        securityProperties.put("org.apache.ws.security.crypto.merlin.keystore.private.password", "changeit");
        securityProperties.put("org.apache.ws.security.crypto.merlin.keystore.alias", "s1as");
        securityProperties.put("org.apache.ws.security.crypto.merlin.keystore.file", "security/ssltest-keystore.jks");
        props.put("securityProperties", securityProperties);
        return new WSS4JInInterceptor(props);
    }

    @Override
    protected List<SecurityStrategy> getSecurityStrategies() {
        WssKeyStoreConfiguration keyStoreConfig = new WssKeyStoreConfiguration("s1as", "changeit", "security/ssltest-cacerts.jks");
        return Collections.singletonList(new EncryptSecurityStrategy(keyStoreConfig));
    }
}

