/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.soap.generator.attachment;

import org.mule.metadata.api.TypeLoader;
import org.mule.runtime.core.api.transformer.TransformerException;
import org.mule.runtime.extension.api.soap.SoapAttachment;
import org.mule.runtime.soap.api.exception.EncodingException;
import org.mule.service.soap.generator.attachment.AttachmentRequestEnricher;
import org.mule.service.soap.generator.attachment.Base64Encoder;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public final class SoapAttachmentRequestEnricher
extends AttachmentRequestEnricher {
    private static final Base64Encoder encoder = new Base64Encoder();

    public SoapAttachmentRequestEnricher(TypeLoader loader) {
        super(loader);
    }

    @Override
    protected void addAttachmentElement(Document bodyDocument, String name, SoapAttachment attachment, Element attachmentElement) {
        attachmentElement.setTextContent(this.toBase64(attachment.getContent()));
    }

    private String toBase64(Object content) {
        try {
            return encoder.transform(content).toString();
        }
        catch (TransformerException e) {
            throw new EncodingException("Could not encode attachment content to base64", (Throwable)e);
        }
    }
}

