/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.soap.metadata;

import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import javax.wsdl.Message;
import javax.wsdl.Part;
import org.mule.metadata.api.TypeLoader;
import org.mule.metadata.api.builder.ObjectFieldTypeBuilder;
import org.mule.metadata.api.builder.ObjectTypeBuilder;
import org.mule.metadata.api.model.MetadataType;
import org.mule.runtime.api.metadata.MetadataResolvingException;
import org.mule.service.soap.metadata.NodeMetadataResolver;
import org.mule.wsdl.parser.model.PortModel;
import org.mule.wsdl.parser.model.WsdlModel;
import org.mule.wsdl.parser.model.operation.OperationModel;
import org.mule.wsdl.parser.model.operation.SoapHeader;

abstract class HeadersMetadataResolver
extends NodeMetadataResolver {
    private final WsdlModel wsdl;
    private final Function<OperationModel, Message> messageRetriever;
    private final Function<OperationModel, List<SoapHeader>> headersRetriever;

    HeadersMetadataResolver(WsdlModel wsdl, PortModel port, TypeLoader loader, Function<OperationModel, Message> messageRetriever, Function<OperationModel, List<SoapHeader>> headersRetriever) {
        super(port, loader, o -> Optional.empty());
        this.wsdl = wsdl;
        this.messageRetriever = messageRetriever;
        this.headersRetriever = headersRetriever;
    }

    @Override
    public MetadataType getMetadata(String operationName) throws MetadataResolvingException {
        OperationModel operation = this.port.getOperation(operationName);
        List<SoapHeader> headers = this.headersRetriever.apply(operation);
        if (!headers.isEmpty()) {
            return this.buildHeaderType(headers, this.messageRetriever.apply(operation));
        }
        return this.nullType;
    }

    private MetadataType buildHeaderType(List<SoapHeader> headers, Message message) throws MetadataResolvingException {
        ObjectTypeBuilder objectType = this.typeBuilder.objectType();
        for (SoapHeader header : headers) {
            ObjectFieldTypeBuilder field = objectType.addField();
            String headerPart = header.getPartName();
            Part part = message.getPart(headerPart);
            if (part != null) {
                field.key(headerPart).value(this.buildPartMetadataType(part));
                continue;
            }
            Message headerMessage = this.wsdl.getMessage(header.getQName());
            field.key(headerPart).value(this.buildPartMetadataType(headerMessage.getPart(headerPart)));
        }
        return objectType.build();
    }
}

