/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.soap.generator;

import io.qameta.allure.Description;
import io.qameta.allure.Step;
import java.util.Collections;
import org.apache.commons.io.IOUtils;
import org.junit.Test;
import org.mockito.Mockito;
import org.mule.runtime.api.metadata.MediaType;
import org.mule.runtime.extension.api.soap.SoapAttachment;
import org.mule.service.soap.SoapTestUtils;
import org.mule.service.soap.generator.AbstractEnricherTestCase;
import org.mule.service.soap.generator.attachment.AttachmentRequestEnricher;

public abstract class AbstractRequestEnricherTestCase
extends AbstractEnricherTestCase {
    @Test
    @Description(value="Enrich a request that contains attachments")
    public void enrich() throws Exception {
        SoapAttachment attachment = this.getTestAttachment();
        AttachmentRequestEnricher enricher = this.getEnricher();
        String request = enricher.enrichRequest(this.testValues.getUploadAttachmentRequest(), Collections.singletonMap("attachment-id", attachment));
        SoapTestUtils.assertSimilarXml(this.getExpectedResult(), request);
    }

    @Step(value="Prepares a test attachment")
    private SoapAttachment getTestAttachment() {
        SoapAttachment attachment = (SoapAttachment)Mockito.mock(SoapAttachment.class);
        Mockito.when((Object)attachment.getContent()).thenReturn((Object)IOUtils.toInputStream((String)"Some Content"));
        Mockito.when((Object)attachment.getContentType()).thenReturn((Object)MediaType.TEXT);
        return attachment;
    }

    protected abstract AttachmentRequestEnricher getEnricher();

    protected abstract String getExpectedResult();
}

