/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.soap.generator;

import io.qameta.allure.Description;
import java.util.Map;
import org.apache.cxf.message.Exchange;
import org.apache.cxf.message.ExchangeImpl;
import org.junit.Before;
import org.junit.Test;
import org.mule.metadata.api.TypeLoader;
import org.mule.service.soap.SoapTestUtils;
import org.mule.service.soap.generator.AbstractEnricherTestCase;
import org.mule.service.soap.generator.attachment.AttachmentResponseEnricher;
import org.mule.service.soap.generator.attachment.MtomResponseEnricher;
import org.mule.service.soap.util.XmlTransformationUtils;
import org.w3c.dom.Document;

public class MtomResponseEnricherTestCase
extends AbstractEnricherTestCase {
    private AttachmentResponseEnricher enricher;

    @Override
    @Before
    public void setup() {
        super.setup();
        Map ops = this.model.getService("TestService").getPort("TestPort").getOperationsMap();
        this.enricher = new MtomResponseEnricher((TypeLoader)this.model.getLoader().getValue(), ops);
    }

    @Test
    @Description(value="Enrich a response that contains attachments")
    public void enrich() throws Exception {
        String response = "<con:downloadAttachmentResponse xmlns:con=\"http://service.soap.service.mule.org/\"><attachment><xop:Include xmlns:xop=\"http://www.w3.org/2004/08/xop/include\" href=\"cid:attachment-id\"/></attachment></con:downloadAttachmentResponse>";
        ExchangeImpl exchange = new ExchangeImpl();
        Document doc = XmlTransformationUtils.stringToDocument((String)response);
        String result = this.enricher.enrich(doc, "downloadAttachment", (Exchange)exchange);
        SoapTestUtils.assertSimilarXml(this.testValues.getDownloadAttachmentResponse(), result);
    }
}

