/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.soap.metadata;

import io.qameta.allure.Description;
import io.qameta.allure.Feature;
import io.qameta.allure.Story;
import java.util.Collection;
import java.util.Iterator;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Test;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.model.NullType;
import org.mule.metadata.api.model.ObjectFieldType;
import org.mule.metadata.api.model.ObjectType;
import org.mule.metadata.api.model.StringType;
import org.mule.runtime.api.metadata.MetadataResolvingException;
import org.mule.runtime.soap.api.client.metadata.SoapOperationMetadata;
import org.mule.service.soap.metadata.AbstractMetadataTestCase;

@Feature(value="WSC Extension")
@Story(value="Metadata")
public class BodyMetadataTestCase
extends AbstractMetadataTestCase {
    @Test
    @Description(value="Checks the dynamic metadata of an operation with required parameters")
    public void operationWithSimpleInputParameterMetadata() throws MetadataResolvingException {
        SoapOperationMetadata result = this.resolver.getInputMetadata("echo");
        MetadataType body = result.getBodyType();
        Collection fields = this.toObjectType(body).getFields();
        Assert.assertThat((Object)fields, (Matcher)Matchers.hasSize((int)1));
        ObjectFieldType operationField = (ObjectFieldType)fields.iterator().next();
        Assert.assertThat((Object)operationField.getKey().getName().getLocalPart(), (Matcher)Is.is((Object)"echo"));
        Collection operationParams = this.toObjectType(operationField.getValue()).getFields();
        Assert.assertThat((Object)operationParams, (Matcher)Matchers.hasSize((int)1));
        ObjectFieldType field = (ObjectFieldType)operationParams.iterator().next();
        Assert.assertThat((Object)field.getKey().getName().getLocalPart(), (Matcher)Is.is((Object)"text"));
        Assert.assertThat((Object)field.getValue(), (Matcher)Is.is((Matcher)Matchers.instanceOf(StringType.class)));
    }

    @Test
    @Description(value="Checks the dynamic metadata for an operation without input parameters")
    public void operationNoInputParametersMetadata() throws MetadataResolvingException {
        SoapOperationMetadata result = this.resolver.getInputMetadata("noParams");
        MetadataType body = result.getBodyType();
        Collection fields = this.toObjectType(body).getFields();
        Assert.assertThat((Object)fields, (Matcher)Matchers.hasSize((int)1));
        ObjectFieldType operationField = (ObjectFieldType)fields.iterator().next();
        Assert.assertThat((Object)operationField.getKey().getName().getLocalPart(), (Matcher)Is.is((Object)"noParams"));
        Collection operationParams = this.toObjectType(operationField.getValue()).getFields();
        Assert.assertThat((Object)operationParams, (Matcher)Matchers.hasSize((int)0));
    }

    @Test
    @Description(value="Checks the dynamic metadata of an operation with a complex input parameter")
    public void operationComplexInputParameterMetadata() throws MetadataResolvingException {
        SoapOperationMetadata result = this.resolver.getInputMetadata("echoAccount");
        MetadataType body = result.getBodyType();
        Collection fields = this.toObjectType(body).getFields();
        Assert.assertThat((Object)fields, (Matcher)Matchers.hasSize((int)1));
        ObjectFieldType operationField = (ObjectFieldType)fields.iterator().next();
        Assert.assertThat((Object)operationField.getKey().getName().getLocalPart(), (Matcher)Is.is((Object)"echoAccount"));
        Collection operationParams = this.toObjectType(operationField.getValue()).getFields();
        Assert.assertThat((Object)operationParams, (Matcher)Matchers.hasSize((int)2));
        Iterator iterator = operationParams.iterator();
        ObjectFieldType accountField = (ObjectFieldType)iterator.next();
        Assert.assertThat((Object)accountField.getKey().getName().getLocalPart(), (Matcher)Is.is((Object)"account"));
        ObjectType accountType = this.toObjectType(accountField.getValue());
        Collection accountFields = accountType.getFields();
        Assert.assertThat((Object)accountFields, (Matcher)Matchers.hasSize((int)4));
        ObjectFieldType name = (ObjectFieldType)iterator.next();
        Assert.assertThat((Object)name.getKey().getName().getLocalPart(), (Matcher)Is.is((Object)"name"));
        Assert.assertThat((Object)name.getValue(), (Matcher)Is.is((Matcher)Matchers.instanceOf(StringType.class)));
    }

    @Test
    @Description(value="Checks the Output Body Metadata for an operation that returns a simple string")
    public void operationWithSimpleOutputTypeMetadata() throws MetadataResolvingException {
        SoapOperationMetadata result = this.resolver.getOutputMetadata("echo");
        Collection resultFields = this.toObjectType(result.getBodyType()).getFields();
        Assert.assertThat((Object)resultFields, (Matcher)Matchers.hasSize((int)1));
        ObjectType echoType = this.toObjectType(((ObjectFieldType)resultFields.iterator().next()).getValue());
        Collection echoFields = echoType.getFields();
        Assert.assertThat((Object)echoFields, (Matcher)Matchers.hasSize((int)1));
        ObjectFieldType textField = (ObjectFieldType)echoFields.iterator().next();
        Assert.assertThat((Object)textField.getKey().getName().getLocalPart(), (Matcher)Is.is((Object)"text"));
        Assert.assertThat((Object)textField.getValue(), (Matcher)Is.is((Matcher)Matchers.instanceOf(StringType.class)));
    }

    @Test
    @Description(value="Checks the Output Body Metadata for an operation that returns a complex element")
    public void operationWithComplexOutputTypeMetadata() throws MetadataResolvingException {
        SoapOperationMetadata result = this.resolver.getOutputMetadata("echoAccount");
        Collection resultFields = this.toObjectType(result.getBodyType()).getFields();
        Assert.assertThat((Object)resultFields, (Matcher)Matchers.hasSize((int)1));
        ObjectType echoType = this.toObjectType(((ObjectFieldType)resultFields.iterator().next()).getValue());
        Collection echoFields = echoType.getFields();
        Assert.assertThat((Object)echoFields, (Matcher)Matchers.hasSize((int)1));
        ObjectFieldType accountField = (ObjectFieldType)echoFields.iterator().next();
        Assert.assertThat((Object)accountField.getKey().getName().getLocalPart(), (Matcher)Is.is((Object)"account"));
        ObjectType objectType = this.toObjectType(accountField.getValue());
        Assert.assertThat((Object)objectType.getFields(), (Matcher)Matchers.hasSize((int)4));
    }

    @Test
    @Description(value="Checks the metadata for an operation that is ONE WAY")
    public void oneWayOperationMetadata() throws MetadataResolvingException {
        SoapOperationMetadata input = this.resolver.getInputMetadata("oneWay");
        SoapOperationMetadata output = this.resolver.getOutputMetadata("oneWay");
        Assert.assertThat((Object)output.getBodyType(), (Matcher)Is.is((Matcher)Matchers.instanceOf(NullType.class)));
        Assert.assertThat((Object)this.toObjectType(input.getBodyType()).getFields(), (Matcher)Matchers.hasSize((int)1));
    }
}

