/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.soap.client;

import java.lang.reflect.Method;
import java.util.Iterator;
import javax.xml.transform.Source;
import org.apache.cxf.Bus;
import org.apache.cxf.binding.soap.SoapVersion;
import org.apache.cxf.binding.soap.SoapVersionFactory;
import org.apache.cxf.bus.spring.SpringBusFactory;
import org.apache.cxf.databinding.DataBinding;
import org.apache.cxf.databinding.stax.StaxDataBinding;
import org.apache.cxf.databinding.stax.StaxDataBindingFeature;
import org.apache.cxf.endpoint.Client;
import org.apache.cxf.frontend.ClientFactoryBean;
import org.apache.cxf.transport.ConduitInitiator;
import org.apache.cxf.transport.ConduitInitiatorManager;
import org.apache.cxf.wsdl.service.factory.ReflectionServiceFactoryBean;
import org.mule.runtime.core.api.util.ClassUtils;
import org.mule.service.soap.conduit.SoapServiceConduitInitiator;

class CxfClientFactory {
    private final Bus bus = (Bus)ClassUtils.withContextClassLoader((ClassLoader)CxfClientFactory.class.getClassLoader(), () -> new SpringBusFactory().createBus((String)null, true));

    CxfClientFactory() {
        this.registerConduitInitiator(new SoapServiceConduitInitiator());
    }

    private void registerConduitInitiator(SoapServiceConduitInitiator initiator) {
        ConduitInitiatorManager extension = (ConduitInitiatorManager)this.bus.getExtension(ConduitInitiatorManager.class);
        extension.registerConduitInitiator("http://cxf.apache.org/transports/http", (ConduitInitiator)initiator);
        extension.registerConduitInitiator("http://schemas.xmlsoap.org/wsdl/soap/", (ConduitInitiator)initiator);
        extension.registerConduitInitiator("http://schemas.xmlsoap.org/soap/http/", (ConduitInitiator)initiator);
        extension.registerConduitInitiator("http://schemas.xmlsoap.org/wsdl/soap/http", (ConduitInitiator)initiator);
        extension.registerConduitInitiator("http://schemas.xmlsoap.org/wsdl/http/", (ConduitInitiator)initiator);
        extension.registerConduitInitiator("http://www.w3.org/2003/05/soap/bindings/HTTP/", (ConduitInitiator)initiator);
        extension.registerConduitInitiator("http://cxf.apache.org/transports/http/configuration", (ConduitInitiator)initiator);
        extension.registerConduitInitiator("http://cxf.apache.org/bindings/xformat", (ConduitInitiator)initiator);
        extension.registerConduitInitiator("http://cxf.apache.org/transports/jms", (ConduitInitiator)initiator);
        extension.registerConduitInitiator("http://mule.codehaus.org/ws", (ConduitInitiator)initiator);
    }

    public Client createClient(String address, String soapVersion) {
        return (Client)ClassUtils.withContextClassLoader((ClassLoader)CxfClientFactory.class.getClassLoader(), () -> {
            ReflectionServiceFactoryBean serviceFactoryBean = new ReflectionServiceFactoryBean();
            serviceFactoryBean.getServiceConfigurations().add(0, new DefaultServiceConfiguration());
            ClientFactoryBean factory = new ClientFactoryBean(serviceFactoryBean);
            factory.setServiceClass(ProxyService.class);
            factory.setDataBinding((DataBinding)new StaxDataBinding());
            factory.getFeatures().add(new StaxDataBindingFeature());
            factory.setAddress(address);
            factory.setBus(this.bus);
            factory.setBindingId(this.getBindingIdForSoapVersion(soapVersion));
            return factory.create();
        });
    }

    private String getBindingIdForSoapVersion(String version) {
        Iterator soapVersions = SoapVersionFactory.getInstance().getVersions();
        while (soapVersions.hasNext()) {
            SoapVersion soapVersion = (SoapVersion)soapVersions.next();
            if (!Double.toString(soapVersion.getVersion()).equals(version)) continue;
            return soapVersion.getBindingId();
        }
        throw new IllegalArgumentException("Invalid Soap version " + version);
    }

    public class DefaultServiceConfiguration
    extends org.apache.cxf.wsdl.service.factory.DefaultServiceConfiguration {
        public Boolean hasOutMessage(Method m) {
            return !m.getName().equals("invokeOneWay");
        }
    }

    private static interface ProxyService {
        public Source invoke(Source var1);

        public void invokeOneWay(Source var1);
    }
}

