/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.soap.security;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import org.apache.wss4j.common.crypto.Merlin;
import org.mule.runtime.extension.api.soap.security.config.WssTrustStoreConfiguration;
import org.mule.service.soap.security.SecurityStrategyCxfAdapter;
import org.mule.service.soap.security.SecurityStrategyType;
import org.mule.service.soap.security.callback.WSPasswordCallbackHandler;
import org.mule.service.soap.security.config.WssTrustStoreConfigurationPropertiesBuilder;

public class WssVerifySignatureSecurityStrategyCxfAdapter
implements SecurityStrategyCxfAdapter {
    private static final String WS_VERIFY_SIGNATURE_PROPERTIES_KEY = "verifySignatureProperties";
    private final WssTrustStoreConfigurationPropertiesBuilder trustStoreConfiguration;

    public WssVerifySignatureSecurityStrategyCxfAdapter(WssTrustStoreConfiguration trustStoreConfiguration) {
        this.trustStoreConfiguration = new WssTrustStoreConfigurationPropertiesBuilder(trustStoreConfiguration);
    }

    public WssVerifySignatureSecurityStrategyCxfAdapter() {
        this.trustStoreConfiguration = null;
    }

    @Override
    public SecurityStrategyType securityType() {
        return SecurityStrategyType.INCOMING;
    }

    @Override
    public Optional<WSPasswordCallbackHandler> buildPasswordCallbackHandler() {
        return Optional.empty();
    }

    @Override
    public String securityAction() {
        return "Signature";
    }

    @Override
    public Map<String, Object> buildSecurityProperties() {
        Properties signatureProps = this.trustStoreConfiguration != null ? this.trustStoreConfiguration.getConfigurationProperties() : this.getDefaultTrustStoreConfigurationProperties();
        return ImmutableMap.builder().put((Object)"signaturePropRefId", (Object)WS_VERIFY_SIGNATURE_PROPERTIES_KEY).put((Object)WS_VERIFY_SIGNATURE_PROPERTIES_KEY, (Object)signatureProps).build();
    }

    private Properties getDefaultTrustStoreConfigurationProperties() {
        Properties properties = new Properties();
        properties.setProperty("org.apache.wss4j.crypto.provider", Merlin.class.getCanonicalName());
        properties.setProperty("load.cacerts", String.valueOf(true));
        return properties;
    }
}

