/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.soap.unit;

import java.io.StringReader;
import java.nio.charset.Charset;
import java.util.Collections;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.cxf.message.Exchange;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.core.Is;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mule.runtime.api.metadata.MediaType;
import org.mule.runtime.soap.api.message.SoapResponse;
import org.mule.service.soap.generator.SoapResponseGenerator;
import org.mule.service.soap.generator.attachment.AttachmentResponseEnricher;
import org.mule.service.soap.xml.util.XMLUtils;
import org.w3c.dom.Document;

public class SoapResponseGeneratorTestCase {
    private static final String TEST_CHARSET = "windows-1252";

    @Test
    public void responseWithCharset() throws XMLStreamException {
        AttachmentResponseEnricher enricher = (AttachmentResponseEnricher)Mockito.mock(AttachmentResponseEnricher.class);
        Mockito.when((Object)enricher.enrich((Document)ArgumentMatchers.any(), (String)ArgumentMatchers.any(), (Exchange)ArgumentMatchers.any())).thenAnswer(a -> XMLUtils.toXml((Document)((Document)a.getArgument(0))));
        Exchange exchange = (Exchange)Mockito.mock(Exchange.class);
        Mockito.when((Object)exchange.get((Object)"mule.soap.attachments")).thenReturn(Collections.emptyMap());
        Mockito.when((Object)exchange.get((Object)"mule.soap.headers")).thenReturn(Collections.emptyMap());
        Mockito.when((Object)exchange.get((Object)"mule.soap.transport.headers")).thenReturn(Collections.singletonMap("content-type", "text/html; charset=windows-1252"));
        SoapResponseGenerator generator = new SoapResponseGenerator(enricher);
        SoapResponse response = generator.generate("dummy", new Object[]{this.getTestXml()}, exchange);
        MediaType contentType = response.getContentType();
        MatcherAssert.assertThat((Object)((Charset)contentType.getCharset().get()).toString(), (Matcher)Is.is((Object)TEST_CHARSET));
    }

    private XMLStreamReader getTestXml() throws XMLStreamException {
        String text = "<foo>This is some XML</foo>";
        StringReader reader = new StringReader(text);
        XMLInputFactory factory = XMLInputFactory.newInstance();
        return factory.createXMLStreamReader(reader);
    }
}

