/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.soap.metadata;

import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import javax.wsdl.Message;
import javax.wsdl.Part;
import javax.xml.namespace.QName;
import org.mule.metadata.api.TypeLoader;
import org.mule.metadata.api.builder.ObjectTypeBuilder;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.model.ObjectFieldType;
import org.mule.metadata.api.model.ObjectType;
import org.mule.metadata.api.utils.MetadataTypeUtils;
import org.mule.runtime.api.metadata.MetadataResolvingException;
import org.mule.service.soap.metadata.NodeMetadataResolver;
import org.mule.service.soap.util.SoapServiceMetadataTypeUtils;
import org.mule.wsdl.parser.model.PortModel;
import org.mule.wsdl.parser.model.operation.OperationModel;

abstract class AttachmentsMetadataResolver
extends NodeMetadataResolver {
    private final Function<OperationModel, Optional<Message>> messageRetriever;

    AttachmentsMetadataResolver(PortModel port, TypeLoader loader, Function<OperationModel, Optional<Part>> partRetriever, Function<OperationModel, Optional<Message>> messageRetriever) {
        super(port, loader, partRetriever);
        this.messageRetriever = messageRetriever;
    }

    @Override
    public MetadataType getMetadata(String operation) throws MetadataResolvingException {
        Part bodyPart = this.getBodyPart(operation);
        MetadataType bodyType = this.buildPartMetadataType(bodyPart);
        List<ObjectFieldType> attachments = SoapServiceMetadataTypeUtils.getAttachmentFields(bodyType);
        if (attachments.isEmpty()) {
            return this.getMultipartAttachments(operation, bodyPart).orElse(this.nullType);
        }
        ObjectTypeBuilder type = this.typeBuilder.objectType();
        attachments.forEach(attachment -> type.addField().key(MetadataTypeUtils.getLocalPart((ObjectFieldType)attachment)).value(attachment.getValue()));
        return type.build();
    }

    private Optional<MetadataType> getMultipartAttachments(String operation, Part bodyPart) {
        Map parts;
        Message message = this.messageRetriever.apply(this.port.getOperation(operation)).orElse(null);
        if (message != null && (parts = message.getParts()) != null) {
            ObjectTypeBuilder type = this.typeBuilder.objectType();
            parts.forEach((partName, partObject) -> {
                QName typeName;
                if (!bodyPart.getName().equals(partName) && (typeName = partObject.getTypeName()) != null && typeName.toString().toLowerCase().contains("binary")) {
                    type.addField().key(partName).value((MetadataType)this.typeBuilder.binaryType().build());
                }
            });
            ObjectType result = type.build();
            if (result.getFields().isEmpty()) {
                return Optional.empty();
            }
            return Optional.of(result);
        }
        return Optional.empty();
    }
}

