/*
 * Decompiled with CFR 0.152.
 */
package org.mule.weave.v2.el.utils;

import java.io.Serializable;
import java.nio.charset.Charset;
import java.util.Optional;
import java.util.OptionalLong;
import org.mule.runtime.api.el.DataTypeAware;
import org.mule.runtime.api.el.ExpressionExecutionException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.metadata.CollectionDataType;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.api.metadata.MapDataType;
import org.mule.runtime.api.metadata.MediaType;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.weave.v2.el.MuleDataWeaveHelper$;
import org.mule.weave.v2.el.TypedValueCapable;
import org.mule.weave.v2.el.utils.MediaTypeHelper$;
import org.mule.weave.v2.model.EvaluationContext;
import org.mule.weave.v2.model.capabilities.UnknownLocationCapable$;
import org.mule.weave.v2.model.structure.KeyValuePair;
import org.mule.weave.v2.model.structure.KeyValuePair$;
import org.mule.weave.v2.model.structure.ObjectSeq;
import org.mule.weave.v2.model.types.NullType$;
import org.mule.weave.v2.model.types.ObjectType$;
import org.mule.weave.v2.model.values.ObjectValue$;
import org.mule.weave.v2.model.values.Value;
import org.mule.weave.v2.model.values.wrappers.RawValueWrapper;
import org.mule.weave.v2.model.values.wrappers.WrapperValue;
import org.mule.weave.v2.module.DataFormat;
import org.mule.weave.v2.module.DataFormatManager$;
import org.mule.weave.v2.module.MimeType;
import org.mule.weave.v2.module.MimeType$;
import org.mule.weave.v2.module.java.JavaInvocationHelper$;
import org.mule.weave.v2.module.option.Settings;
import org.mule.weave.v2.module.pojo.JavaDataFormat$;
import org.mule.weave.v2.module.pojo.reader.JavaBeanObjectValue;
import org.mule.weave.v2.module.pojo.reader.JavaBeanObjectValue$;
import org.mule.weave.v2.module.pojo.reader.JavaValue;
import org.mule.weave.v2.module.pojo.writer.JavaWriter;
import org.mule.weave.v2.module.writer.ConfigurableEncoding;
import org.mule.weave.v2.module.writer.ConfigurableEncoding$;
import org.mule.weave.v2.module.writer.Writer;
import org.mule.weave.v2.module.writer.WriterHelper$;
import org.mule.weave.v2.parser.ast.structure.DocumentNode;
import org.mule.weave.v2.parser.location.LocationCapable;
import org.mule.weave.v2.runtime.ExecutableWeave;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.runtime.BoxedUnit;

public final class DataTypeHelper$ {
    public static DataTypeHelper$ MODULE$;

    static {
        new DataTypeHelper$();
    }

    public TypedValue<?> transformToExpectedDataType(Value<?> result, String mimeTypeString, DataType expectedDataType, ExecutableWeave<DocumentNode> executable, EvaluationContext ctx) {
        TypedValue typedValue;
        block4: {
            while (true) {
                JavaValue javaValue;
                Value value;
                if ((value = result) instanceof RawValueWrapper) {
                    RawValueWrapper rawValueWrapper = (RawValueWrapper)value;
                    DataType dataType = DataType.builder().fromObject(rawValueWrapper.rawData()).mediaType(MediaType.parse((String)rawValueWrapper.mimeType().toString())).build();
                    typedValue = dataType.isCompatibleWith(expectedDataType) ? MuleDataWeaveHelper$.MODULE$.asTypedValue(rawValueWrapper, ctx) : this.transformToDataType(expectedDataType, result, mimeTypeString, executable, ctx);
                    break block4;
                }
                if (value instanceof JavaValue && this.isCompatibleWith(javaValue = (JavaValue)value, expectedDataType)) {
                    DataTypeAware dataTypeAware = (DataTypeAware)javaValue.underlying();
                    typedValue = new TypedValue(javaValue.underlying(), dataTypeAware.getDataType());
                    break block4;
                }
                if (value instanceof TypedValueCapable) {
                    TypedValueCapable typedValueCapable = (TypedValueCapable)value;
                    typedValue = typedValueCapable.typedValue().getDataType().isCompatibleWith(expectedDataType) ? typedValueCapable.typedValue() : this.transformToDataType(expectedDataType, result, mimeTypeString, executable, ctx);
                    break block4;
                }
                if (!(value instanceof WrapperValue)) break;
                WrapperValue wrapperValue = (WrapperValue)value;
                Value value2 = wrapperValue.value(ctx);
                result = value2;
            }
            typedValue = this.transformToDataType(expectedDataType, result, mimeTypeString, executable, ctx);
        }
        return typedValue;
    }

    private boolean isCompatibleWith(JavaValue<?> javaValue, DataType expectedDataType) {
        return javaValue.underlying() instanceof DataTypeAware && this.matchDataType(expectedDataType, ((DataTypeAware)javaValue.underlying()).getDataType());
    }

    public TypedValue<?> toJavaValue(Value<?> result, DataType expectedDataType, EvaluationContext ctx) {
        TypedValue<Object> typedValue;
        block4: {
            while (true) {
                JavaValue javaValue;
                Value value;
                if ((value = result) instanceof TypedValueCapable) {
                    TypedValueCapable typedValueCapable = (TypedValueCapable)value;
                    DataType actualDataType = typedValueCapable.typedValue().getDataType();
                    typedValue = this.matchDataType(expectedDataType, actualDataType) ? typedValueCapable.typedValue() : this.transformToJavaDataType(expectedDataType, result, ctx);
                    break block4;
                }
                if (value instanceof JavaValue && this.isCompatibleWith(javaValue = (JavaValue)value, expectedDataType)) {
                    DataTypeAware dataTypeAware = (DataTypeAware)javaValue.underlying();
                    typedValue = new TypedValue<Object>(javaValue.underlying(), dataTypeAware.getDataType());
                    break block4;
                }
                if (value instanceof RawValueWrapper) {
                    RawValueWrapper rawValueWrapper = (RawValueWrapper)value;
                    DataType dataType = DataType.builder().fromObject(rawValueWrapper.rawData()).mediaType(MediaType.parse((String)rawValueWrapper.mimeType().toString())).build();
                    typedValue = dataType.isCompatibleWith(expectedDataType) ? MuleDataWeaveHelper$.MODULE$.asTypedValue(rawValueWrapper, ctx) : this.transformToJavaDataType(expectedDataType, result, ctx);
                    break block4;
                }
                if (!(value instanceof WrapperValue)) break;
                WrapperValue wrapperValue = (WrapperValue)value;
                Value value2 = wrapperValue.value(ctx);
                result = value2;
            }
            typedValue = this.transformToJavaDataType(expectedDataType, result, ctx);
        }
        return typedValue;
    }

    private boolean matchDataType(DataType expectedDataType, DataType actualDataType) {
        boolean bl;
        block9: {
            while (this.matchesMediaType(actualDataType.getMediaType(), expectedDataType.getMediaType()) && expectedDataType.getType().isAssignableFrom(actualDataType.getType())) {
                boolean bl2;
                DataType dataType = expectedDataType;
                if (dataType instanceof CollectionDataType) {
                    boolean bl3;
                    CollectionDataType collectionDataType = (CollectionDataType)dataType;
                    DataType dataType2 = actualDataType;
                    if (dataType2 instanceof CollectionDataType) {
                        CollectionDataType collectionDataType2 = (CollectionDataType)dataType2;
                        actualDataType = collectionDataType2.getItemDataType();
                        expectedDataType = collectionDataType.getItemDataType();
                        continue;
                    }
                    bl2 = bl3 = false;
                } else if (dataType instanceof MapDataType) {
                    boolean bl4;
                    MapDataType mapDataType = (MapDataType)dataType;
                    DataType dataType3 = actualDataType;
                    if (dataType3 instanceof MapDataType) {
                        MapDataType mapDataType2 = (MapDataType)dataType3;
                        if (this.matchDataType(mapDataType.getKeyDataType(), mapDataType2.getKeyDataType())) {
                            actualDataType = mapDataType2.getValueDataType();
                            expectedDataType = mapDataType.getValueDataType();
                            continue;
                        }
                        bl4 = false;
                    } else {
                        bl4 = false;
                    }
                    bl2 = bl4;
                } else {
                    bl2 = true;
                }
                bl = bl2;
                break block9;
            }
            bl = false;
        }
        return bl;
    }

    private boolean matchesMediaType(MediaType actualDataType, MediaType expectedDataType) {
        boolean actualJava = this.isJavaMediaType(actualDataType);
        boolean expectedIsJava = this.isJavaMediaType(expectedDataType);
        return actualJava || expectedIsJava ? actualJava && expectedIsJava : expectedDataType.matches(actualDataType);
    }

    public boolean isJavaMediaType(MediaType expectedMediaType) {
        return expectedMediaType.matches(MediaType.ANY) || expectedMediaType.matches(MediaType.APPLICATION_JAVA) || JavaDataFormat$.MODULE$.isJavaMimeType(MediaTypeHelper$.MODULE$.toRfcStringWithoutParams(expectedMediaType));
    }

    private TypedValue<Object> transformToJavaDataType(DataType expectedDataType, Value<?> result, EvaluationContext ctx) {
        Object java = this.transformToJava(expectedDataType, result, ctx);
        return new TypedValue(java, DataType.builder().fromObject(java).mediaType(expectedDataType.getMediaType()).build());
    }

    private Object transformToJava(DataType expectedDataType, Value<?> result, EvaluationContext ctx) {
        Optional optional;
        if (NullType$.MODULE$.accepts(result, ctx)) {
            optional = Optional.class.isAssignableFrom(expectedDataType.getType()) ? Optional.empty() : null;
        } else {
            Object object;
            DataType dataType = expectedDataType;
            if (dataType instanceof CollectionDataType) {
                CollectionDataType collectionDataType = (CollectionDataType)dataType;
                object = JavaInvocationHelper$.MODULE$.transformToJavaCollection(result, collectionDataType.getItemDataType().getType(), expectedDataType.getType(), ctx);
            } else if (dataType instanceof MapDataType) {
                MapDataType mapDataType = (MapDataType)dataType;
                object = this.transformToJavaMap(result, mapDataType.getValueDataType().getType(), mapDataType.getType(), ctx);
            } else {
                object = JavaInvocationHelper$.MODULE$.transformToJava(result, expectedDataType.getType(), ctx);
            }
            optional = object;
        }
        return optional;
    }

    private Object transformToJavaMap(Value<?> arg, Class<?> mapValueClass, Class<?> mapClass, EvaluationContext ctx) {
        JavaWriter writer = JavaDataFormat$.MODULE$.defaultSettingsWriter((Option)None$.MODULE$);
        boolean isValueATypedValue = TypedValue.class.isAssignableFrom(mapValueClass);
        Iterator coercedValues = ((ObjectSeq)ObjectType$.MODULE$.coerce(arg, ctx).evaluate(ctx)).toIterator(ctx).map((Function1 & Serializable & scala.Serializable)kvp -> {
            Value entryValue = kvp._2();
            Value value = this.transformToJavaMapValue$1(entryValue, isValueATypedValue, ctx, mapValueClass);
            return new KeyValuePair(kvp._1(), value, KeyValuePair$.MODULE$.apply$default$3());
        });
        Value valueToWrite = JavaInvocationHelper$.MODULE$.adaptToJavaClass((Value)ObjectValue$.MODULE$.apply(coercedValues, (LocationCapable)UnknownLocationCapable$.MODULE$), mapClass, ctx);
        writer.writeValue(valueToWrite, ctx);
        return writer.result();
    }

    private TypedValue<Object> transformToDataType(DataType expectedDataType, Value<?> result, String mimeTypeString, ExecutableWeave<DocumentNode> executable, EvaluationContext ctx) {
        Option contentType = DataFormatManager$.MODULE$.byContentType(mimeTypeString, ctx);
        MimeType mimeType = MimeType$.MODULE$.fromSimpleString(mimeTypeString);
        Tuple2 writer = (Tuple2)executable.declaredOutput(ctx).flatMap((Function1 & Serializable & scala.Serializable)df -> {
            None$ none$;
            if (df.acceptsMimeType(mimeType)) {
                String actualMimeTypeString = (String)executable.outputDataFormatMimeType(ctx).get();
                Writer thisWriter = df.writer((Option)None$.MODULE$, MimeType$.MODULE$.fromSimpleString(actualMimeTypeString), ctx);
                executable.configureWriter(thisWriter, ctx);
                none$ = new Some((Object)new Tuple2((Object)thisWriter, (Object)actualMimeTypeString));
            } else {
                none$ = None$.MODULE$;
            }
            return none$;
        }).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            Writer defaultWriter = ((DataFormat)contentType.getOrElse((Function0 & Serializable & scala.Serializable)() -> {
                throw new ExpressionExecutionException(I18nMessageFactory.createStaticMessage((String)new StringBuilder(17).append("Invalid mime-type").append(mimeTypeString).toString()));
            })).writer((Option)None$.MODULE$, mimeType, ctx);
            Settings settings = defaultWriter.settings();
            if (settings instanceof ConfigurableEncoding) {
                BoxedUnit boxedUnit;
                ConfigurableEncoding configurableEncoding = (ConfigurableEncoding)settings;
                Optional charset = expectedDataType.getMediaType().getCharset();
                if (charset.isPresent()) {
                    configurableEncoding.set(ConfigurableEncoding$.MODULE$.encodingPropertyName(), (Object)Option$.MODULE$.apply((Object)((Charset)charset.get()).name()));
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                BoxedUnit boxedUnit2 = boxedUnit;
            } else {
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
            return new Tuple2((Object)defaultWriter, (Object)mimeTypeString);
        });
        Tuple2 tuple2 = WriterHelper$.MODULE$.writeAndGetResult((Writer)writer._1(), (Function0 & Serializable & scala.Serializable)() -> result, (LocationCapable)UnknownLocationCapable$.MODULE$, WriterHelper$.MODULE$.writeAndGetResult$default$4(), ctx);
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Object value = tuple2._1();
        Charset charset = (Charset)tuple2._2();
        Tuple2 tuple22 = new Tuple2(value, (Object)charset);
        Tuple2 tuple23 = tuple22;
        Object value2 = tuple23._1();
        Charset charset2 = (Charset)tuple23._2();
        OptionalLong length = MuleDataWeaveHelper$.MODULE$.calculateLength(value2);
        Object wrappedValue = MuleDataWeaveHelper$.MODULE$.wrapIntoCursorProviderIfRequired(value2, ctx);
        DataType dataType = DataType.builder().fromObject(wrappedValue).mediaType((String)writer._2()).charset(charset2).build();
        return new TypedValue(wrappedValue, dataType, length);
    }

    public Option<DataType> calculateDataType(Value<?> value, EvaluationContext ctx) {
        None$ none$;
        block2: {
            while (true) {
                Value value2;
                if ((value2 = value) instanceof TypedValueCapable) {
                    TypedValueCapable typedValueCapable = (TypedValueCapable)value2;
                    none$ = new Some((Object)typedValueCapable.typedValue().getDataType());
                    break block2;
                }
                if (!(value2 instanceof WrapperValue)) break;
                WrapperValue wrapperValue = (WrapperValue)value2;
                Value value3 = wrapperValue.value(ctx);
                value = value3;
            }
            none$ = None$.MODULE$;
        }
        return none$;
    }

    private final Value transformToJavaMapValue$1(Value entryValue, boolean isValueATypedValue$1, EvaluationContext ctx$1, Class mapValueClass$1) {
        JavaBeanObjectValue javaBeanObjectValue;
        block7: {
            Value value;
            while (true) {
                if ((value = entryValue) instanceof TypedValueCapable) {
                    TypedValueCapable typedValueCapable = (TypedValueCapable)value;
                    if (isValueATypedValue$1) {
                        javaBeanObjectValue = JavaBeanObjectValue$.MODULE$.apply(typedValueCapable.typedValue(), (Function0 & Serializable & scala.Serializable)() -> typedValueCapable.location().locationString());
                        break block7;
                    }
                }
                if (value instanceof RawValueWrapper) {
                    RawValueWrapper rawValueWrapper = (RawValueWrapper)value;
                    if (isValueATypedValue$1) {
                        TypedValue<Object> typedValue = MuleDataWeaveHelper$.MODULE$.asTypedValue(rawValueWrapper, ctx$1);
                        javaBeanObjectValue = JavaBeanObjectValue$.MODULE$.apply(typedValue, (Function0 & Serializable & scala.Serializable)() -> rawValueWrapper.location().locationString());
                        break block7;
                    }
                }
                if (!(value instanceof WrapperValue)) break;
                WrapperValue wrapperValue = (WrapperValue)value;
                entryValue = wrapperValue.value(ctx$1);
            }
            if (isValueATypedValue$1) {
                JavaWriter innerWriter = JavaDataFormat$.MODULE$.writer((Option)None$.MODULE$, JavaDataFormat$.MODULE$.writer$default$2(), ctx$1);
                innerWriter.writeValue(value, ctx$1);
                Object result = innerWriter.result();
                DataType dataType = DataType.builder().fromObject(result).mediaType((String)value.schema(ctx$1).flatMap((Function1 & Serializable & scala.Serializable)x$1 -> x$1.mimeType(ctx$1)).getOrElse((Function0 & Serializable & scala.Serializable)() -> "application/java")).build();
                javaBeanObjectValue = JavaBeanObjectValue$.MODULE$.apply((Object)new TypedValue(result, dataType), (Function0 & Serializable & scala.Serializable)() -> value.location().locationString());
            } else {
                javaBeanObjectValue = JavaInvocationHelper$.MODULE$.adaptToJavaClass(entryValue, mapValueClass$1, ctx$1);
            }
        }
        return javaBeanObjectValue;
    }

    private DataTypeHelper$() {
        MODULE$ = this;
    }
}

