/*
 * Decompiled with CFR 0.152.
 */
package org.mule.modules.salesforce;

import com.sforce.async.AsyncApiException;
import com.sforce.async.BatchInfo;
import com.sforce.async.BatchRequest;
import com.sforce.async.BatchResult;
import com.sforce.async.BulkConnection;
import com.sforce.async.ConcurrencyMode;
import com.sforce.async.ContentType;
import com.sforce.async.JobInfo;
import com.sforce.async.OperationEnum;
import com.sforce.async.QueryResultList;
import com.sforce.soap.partner.AssignmentRuleHeader_element;
import com.sforce.soap.partner.CallOptions_element;
import com.sforce.soap.partner.DeleteResult;
import com.sforce.soap.partner.DescribeGlobalResult;
import com.sforce.soap.partner.DescribeSObjectResult;
import com.sforce.soap.partner.EmptyRecycleBinResult;
import com.sforce.soap.partner.GetDeletedResult;
import com.sforce.soap.partner.GetUpdatedResult;
import com.sforce.soap.partner.GetUserInfoResult;
import com.sforce.soap.partner.LeadConvert;
import com.sforce.soap.partner.LeadConvertResult;
import com.sforce.soap.partner.PartnerConnection;
import com.sforce.soap.partner.QueryResult;
import com.sforce.soap.partner.SaveResult;
import com.sforce.soap.partner.SearchRecord;
import com.sforce.soap.partner.SearchResult;
import com.sforce.soap.partner.UpsertResult;
import com.sforce.soap.partner.sobject.SObject;
import com.sforce.ws.ConnectionException;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.SequenceInputStream;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.joda.time.DateTime;
import org.mule.api.MuleContext;
import org.mule.api.MuleException;
import org.mule.api.callback.SourceCallback;
import org.mule.api.callback.StopSourceCallback;
import org.mule.api.context.MuleContextAware;
import org.mule.api.registry.MuleRegistry;
import org.mule.api.store.ObjectStore;
import org.mule.api.store.ObjectStoreException;
import org.mule.api.store.ObjectStoreManager;
import org.mule.api.transformer.Transformer;
import org.mule.common.query.DsqlQuery;
import org.mule.common.query.QueryVisitor;
import org.mule.modules.salesforce.ObjectStoreHelper;
import org.mule.modules.salesforce.SalesforceBayeuxClient;
import org.mule.modules.salesforce.SalesforceBayeuxMessageListener;
import org.mule.modules.salesforce.SalesforceException;
import org.mule.modules.salesforce.SalesforcePagingDelegate;
import org.mule.modules.salesforce.SalesforceUtils;
import org.mule.modules.salesforce.SfdcQueryVisitor;
import org.mule.modules.salesforce.api.SalesforceExceptionHandlerAdapter;
import org.mule.modules.salesforce.api.SalesforceHeader;
import org.mule.modules.salesforce.api.SalesforceRestAdapter;
import org.mule.modules.salesforce.api.SalesforceSoapAdapter;
import org.mule.modules.salesforce.bulk.SaveResultToBulkOperationTransformer;
import org.mule.modules.salesforce.bulk.UpsertResultToBulkOperationTransformer;
import org.mule.modules.salesforce.lazystream.impl.LazyQueryResultInputStream;
import org.mule.streaming.PagingConfiguration;
import org.mule.streaming.ProviderAwarePagingDelegate;
import org.springframework.util.StringUtils;

public abstract class BaseSalesforceConnector
implements MuleContextAware {
    private static final Logger LOGGER = Logger.getLogger(BaseSalesforceConnector.class);
    private ObjectStoreManager objectStoreManager;
    private ObjectStore<? extends Serializable> timeObjectStore;
    private String clientId;
    private String assignmentRuleId;
    private Boolean useDefaultRule;
    private Integer batchSobjectMaxDepth;
    private Boolean allowFieldTruncationSupport;
    private ObjectStoreHelper objectStoreHelper;
    private MuleRegistry registry;
    private static final List<Subscription> subscriptions = new ArrayList<Subscription>();
    private SalesforceBayeuxClient bc;

    protected abstract PartnerConnection getConnection();

    protected abstract BulkConnection getBulkConnection();

    protected abstract String getSessionId();

    protected abstract boolean isReadyToSubscribe();

    protected SalesforceBayeuxClient getBayeuxClient() {
        try {
            if (this.bc == null && this.getConnection() != null && this.getConnection().getConfig() != null) {
                this.bc = new SalesforceBayeuxClient(this);
                if (!this.bc.isHandshook()) {
                    this.bc.handshake();
                }
            }
        }
        catch (MalformedURLException e) {
            LOGGER.error((Object)e.getMessage());
        }
        return this.bc;
    }

    protected boolean isInitializedBayeuxClient() {
        return this.bc != null;
    }

    protected void setBayeuxClient(SalesforceBayeuxClient bc) {
        this.bc = bc;
    }

    protected void setObjectStoreHelper(ObjectStoreHelper objectStoreHelper) {
        this.objectStoreHelper = objectStoreHelper;
    }

    public List<SaveResult> create(String type, List<Map<String, Object>> objects, Map<SalesforceHeader, Object> headers) throws Exception {
        SObject[] sObjects = SalesforceUtils.toSObjectList(type, objects);
        return SalesforceUtils.enrichWithPayload(sObjects, this.getSalesforceSoapAdapter(headers).create(sObjects));
    }

    public JobInfo createJob(OperationEnum operation, String type, String externalIdFieldName, ContentType contentType, ConcurrencyMode concurrencyMode) throws Exception {
        return this.createJobInfo(operation, type, externalIdFieldName, contentType, concurrencyMode);
    }

    public JobInfo closeJob(String jobId) throws Exception {
        return this.getSalesforceRestAdapter().closeJob(jobId);
    }

    public JobInfo abortJob(String jobId) throws Exception {
        return this.getSalesforceRestAdapter().abortJob(jobId);
    }

    public JobInfo jobInfo(String jobId) throws Exception {
        return this.getSalesforceRestAdapter().getJobStatus(jobId);
    }

    public BatchInfo createBatch(JobInfo jobInfo, List<Map<String, Object>> objects) throws Exception {
        return this.createBatchAndCompleteRequest(jobInfo, objects);
    }

    public BatchInfo createBatchStream(JobInfo jobInfo, InputStream stream) throws Exception {
        return this.getSalesforceRestAdapter().createBatchFromStream(jobInfo, stream);
    }

    public BatchInfo createBatchForQuery(JobInfo jobInfo, String query) throws Exception {
        ByteArrayInputStream queryStream = new ByteArrayInputStream(query.getBytes());
        return this.createBatchForQuery(jobInfo, queryStream);
    }

    public BatchInfo createBulk(String type, List<Map<String, Object>> objects) throws Exception {
        return this.createBatchAndCompleteRequest(this.createJobInfo(OperationEnum.insert, type), objects);
    }

    public SaveResult createSingle(String type, Map<String, Object> object, Map<SalesforceHeader, Object> headers) throws Exception {
        SaveResult[] saveResults = this.getSalesforceSoapAdapter(headers).create(new SObject[]{SalesforceUtils.toSObject(type, object)});
        if (saveResults.length > 0) {
            return saveResults[0];
        }
        return null;
    }

    public List<SaveResult> update(String type, List<Map<String, Object>> objects, Map<SalesforceHeader, Object> headers) throws Exception {
        SObject[] sObjects = SalesforceUtils.toSObjectList(type, objects);
        return SalesforceUtils.enrichWithPayload(sObjects, this.getSalesforceSoapAdapter(headers).update(sObjects));
    }

    public SaveResult updateSingle(String type, Map<String, Object> object, Map<SalesforceHeader, Object> headers) throws Exception {
        return this.getSalesforceSoapAdapter(headers).update(new SObject[]{SalesforceUtils.toSObject(type, object)})[0];
    }

    public BatchInfo updateBulk(String type, List<Map<String, Object>> objects) throws Exception {
        return this.createBatchAndCompleteRequest(this.createJobInfo(OperationEnum.update, type), objects);
    }

    public List<UpsertResult> upsert(String externalIdFieldName, String type, List<Map<String, Object>> objects, Map<SalesforceHeader, Object> headers) throws Exception {
        SObject[] sObjects = SalesforceUtils.toSObjectList(type, objects);
        return SalesforceUtils.enrichWithPayload(sObjects, this.getSalesforceSoapAdapter(headers).upsert(externalIdFieldName, sObjects));
    }

    public BatchInfo upsertBulk(String type, String externalIdFieldName, List<Map<String, Object>> objects) throws Exception {
        return this.createBatchAndCompleteRequest(this.createJobInfo(OperationEnum.upsert, type, externalIdFieldName, null, null), objects);
    }

    public BatchInfo batchInfo(BatchInfo batchInfo) throws Exception {
        return this.getSalesforceRestAdapter().getBatchInfo(batchInfo.getJobId(), batchInfo.getId());
    }

    public BatchResult batchResult(BatchInfo batchInfo) throws Exception {
        return this.getSalesforceRestAdapter().getBatchResult(batchInfo.getJobId(), batchInfo.getId());
    }

    public InputStream batchResultStream(BatchInfo batchInfo) throws Exception {
        return this.getSalesforceRestAdapter().getBatchResultStream(batchInfo.getJobId(), batchInfo.getId());
    }

    public InputStream queryResultStream(BatchInfo batchInfo) throws Exception {
        QueryResultList queryResultList = this.getSalesforceRestAdapter().getQueryResultList(batchInfo.getJobId(), batchInfo.getId());
        String[] jobResultIds = queryResultList.getResult();
        LOGGER.debug((Object)String.format("SF queryResultStream for JobId[%s] BatchId[%s] - Pages[%s]", batchInfo.getJobId(), batchInfo.getId(), jobResultIds.length));
        if (jobResultIds.length > 0) {
            LinkedList<LazyQueryResultInputStream> inputStreams = new LinkedList<LazyQueryResultInputStream>();
            for (String jobResultId : jobResultIds) {
                inputStreams.add(new LazyQueryResultInputStream(this.getSalesforceRestAdapter(), batchInfo.getJobId(), batchInfo.getId(), jobResultId));
            }
            return new SequenceInputStream(Collections.enumeration(inputStreams));
        }
        return null;
    }

    public DescribeGlobalResult describeGlobal() throws Exception {
        return this.getSalesforceSoapAdapter().describeGlobal();
    }

    public List<Map<String, Object>> retrieve(String type, List<String> ids, List<String> fields, Map<SalesforceHeader, Object> headers) throws Exception {
        String fiedsCommaDelimited = StringUtils.collectionToCommaDelimitedString(fields);
        SObject[] sObjects = this.getSalesforceSoapAdapter(headers).retrieve(fiedsCommaDelimited, type, ids.toArray(new String[ids.size()]));
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>();
        if (sObjects != null) {
            for (SObject sObject : sObjects) {
                result.add(SalesforceUtils.toMap(sObject));
            }
        }
        return result;
    }

    public ProviderAwarePagingDelegate<Map<String, Object>, BaseSalesforceConnector> query(String query, PagingConfiguration pagingConfiguration, Map<SalesforceHeader, Object> headers) throws Exception {
        return new SalesforcePagingDelegate(query, headers){

            @Override
            protected QueryResult doQuery(PartnerConnection connection, String query) throws ConnectionException {
                return connection.query(query);
            }
        };
    }

    public String toNativeQuery(DsqlQuery query) {
        SfdcQueryVisitor visitor = new SfdcQueryVisitor();
        query.accept((QueryVisitor)visitor);
        return visitor.dsqlQuery();
    }

    public List<Map<String, Object>> nonPaginatedQuery(String query, Map<SalesforceHeader, Object> headers) throws Exception {
        QueryResult queryResult = this.getSalesforceSoapAdapter(headers).query(query);
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>();
        while (queryResult != null) {
            for (SObject object : queryResult.getRecords()) {
                result.add(SalesforceUtils.toMap(object));
            }
            if (queryResult.isDone()) break;
            queryResult = this.getSalesforceSoapAdapter(headers).queryMore(queryResult.getQueryLocator());
        }
        return result;
    }

    public ProviderAwarePagingDelegate<Map<String, Object>, BaseSalesforceConnector> queryAll(String query, PagingConfiguration pagingConfiguration, Map<SalesforceHeader, Object> headers) throws Exception {
        return new SalesforcePagingDelegate(query, headers){

            @Override
            protected QueryResult doQuery(PartnerConnection connection, String query) throws ConnectionException {
                return connection.queryAll(query);
            }
        };
    }

    public List<Map<String, Object>> search(String query, Map<SalesforceHeader, Object> headers) throws Exception {
        SearchResult searchResult = this.getSalesforceSoapAdapter(headers).search(query);
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>();
        for (SearchRecord object : searchResult.getSearchRecords()) {
            result.add(SalesforceUtils.toMap(object.getRecord()));
        }
        return result;
    }

    public Map<String, Object> querySingle(String query, Map<SalesforceHeader, Object> headers) throws Exception {
        SObject[] result = this.getSalesforceSoapAdapter(headers).query(query).getRecords();
        if (result.length > 0) {
            return SalesforceUtils.toMap(result[0]);
        }
        return null;
    }

    public LeadConvertResult convertLead(String leadId, String contactId, String accountId, Boolean overWriteLeadSource, Boolean doNotCreateOpportunity, String opportunityName, String convertedStatus, Boolean sendEmailToOwner, Map<SalesforceHeader, Object> headers) throws Exception {
        LeadConvert leadConvert = new LeadConvert();
        leadConvert.setLeadId(leadId);
        leadConvert.setContactId(contactId);
        leadConvert.setAccountId(accountId);
        leadConvert.setOverwriteLeadSource(overWriteLeadSource);
        leadConvert.setDoNotCreateOpportunity(doNotCreateOpportunity);
        if (opportunityName != null) {
            leadConvert.setOpportunityName(opportunityName);
        }
        leadConvert.setConvertedStatus(convertedStatus);
        leadConvert.setSendNotificationEmail(sendEmailToOwner);
        LeadConvert[] list = new LeadConvert[]{leadConvert};
        return this.getSalesforceSoapAdapter(headers).convertLead(list)[0];
    }

    public List<EmptyRecycleBinResult> emptyRecycleBin(List<String> ids, Map<SalesforceHeader, Object> headers) throws Exception {
        return Arrays.asList(this.getSalesforceSoapAdapter(headers).emptyRecycleBin(ids.toArray(new String[ids.size()])));
    }

    public Calendar getServerTimestamp() throws Exception {
        return this.getSalesforceSoapAdapter().getServerTimestamp().getTimestamp();
    }

    public List<DeleteResult> delete(List<String> ids, Map<SalesforceHeader, Object> headers) throws Exception {
        return Arrays.asList(this.getSalesforceSoapAdapter(headers).delete(ids.toArray(new String[ids.size()])));
    }

    public BatchInfo hardDeleteBulk(String type, List<Map<String, Object>> objects) throws Exception {
        return this.createBatchAndCompleteRequest(this.createJobInfo(OperationEnum.hardDelete, type), objects);
    }

    public GetUpdatedResult getUpdatedRange(String type, Calendar startTime, Calendar endTime, Map<SalesforceHeader, Object> headers) throws Exception {
        if (endTime == null) {
            Calendar serverTime = this.getSalesforceSoapAdapter().getServerTimestamp().getTimestamp();
            endTime = (Calendar)serverTime.clone();
        }
        if (endTime.getTimeInMillis() - startTime.getTimeInMillis() < 60000L) {
            endTime.add(12, 1);
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("Getting updated " + type + " objects between " + startTime.getTime() + " and " + endTime.getTime()));
        }
        return this.getSalesforceSoapAdapter(headers).getUpdated(type, startTime, endTime);
    }

    public GetDeletedResult getDeletedRange(String type, Calendar startTime, Calendar endTime, Map<SalesforceHeader, Object> headers) throws Exception {
        Calendar serverTime;
        if (endTime == null && (endTime = (Calendar)(serverTime = this.getSalesforceSoapAdapter().getServerTimestamp().getTimestamp()).clone()).getTimeInMillis() - startTime.getTimeInMillis() < 60000L) {
            endTime.add(12, 1);
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("Getting deleted " + type + " objects between " + startTime.getTime() + " and " + endTime.getTime()));
        }
        return this.getSalesforceSoapAdapter(headers).getDeleted(type, startTime, endTime);
    }

    public DescribeSObjectResult describeSObject(String type) throws Exception {
        return this.getSalesforceSoapAdapter().describeSObject(type);
    }

    public GetDeletedResult getDeleted(String type, int duration, Map<SalesforceHeader, Object> headers) throws Exception {
        Calendar serverTime = this.getSalesforceSoapAdapter().getServerTimestamp().getTimestamp();
        Calendar startTime = (Calendar)serverTime.clone();
        Calendar endTime = (Calendar)serverTime.clone();
        startTime.add(12, -duration);
        return this.getDeletedRange(type, startTime, endTime, headers);
    }

    public GetUpdatedResult getUpdated(String type, int duration, Map<SalesforceHeader, Object> headers) throws Exception {
        Calendar serverTime = this.getSalesforceSoapAdapter().getServerTimestamp().getTimestamp();
        Calendar startTime = (Calendar)serverTime.clone();
        Calendar endTime = (Calendar)serverTime.clone();
        startTime.add(12, -duration);
        return this.getUpdatedRange(type, startTime, endTime, headers);
    }

    public List<Map<String, Object>> getUpdatedObjects(String type, int initialTimeWindow, List<String> fields, Map<SalesforceHeader, Object> headers) throws Exception {
        GetUpdatedResult getUpdatedResult;
        Calendar now = (Calendar)this.getSalesforceSoapAdapter().getServerTimestamp().getTimestamp().clone();
        boolean initialTimeWindowUsed = false;
        ObjectStoreHelper objectStoreHelper = this.getObjectStoreHelper(this.getSalesforceSoapAdapter().getConfig().getUsername());
        Calendar startTime = objectStoreHelper.getTimestamp(type);
        if (startTime == null) {
            startTime = (Calendar)now.clone();
            startTime.add(12, -1 * initialTimeWindow);
            initialTimeWindowUsed = true;
        }
        if ((getUpdatedResult = this.getUpdatedRange(type, startTime, now, headers)).getLatestDateCovered().equals(startTime) && !initialTimeWindowUsed && getUpdatedResult.getIds().length > 0) {
            LOGGER.debug((Object)"Ignoring duplicated results from getUpdated() call");
            return Collections.emptyList();
        }
        List<Map<String, Object>> updatedObjects = this.retrieve(type, Arrays.asList(getUpdatedResult.getIds()), fields, headers);
        objectStoreHelper.updateTimestamp(getUpdatedResult, type);
        return updatedObjects;
    }

    public void resetUpdatedObjectsTimestamp(String type) throws ObjectStoreException {
        if (this.getTimeObjectStore() == null) {
            LOGGER.warn((Object)"Trying to reset updated objects timestamp but no object store has been set, was getUpdatedObjects ever executed?");
            return;
        }
        ObjectStoreHelper objectStoreHelper = this.getObjectStoreHelper(this.getSalesforceSoapAdapter().getConfig().getUsername());
        objectStoreHelper.resetTimestamps(type);
    }

    public void setPassword(String userId, String newPassword, Map<SalesforceHeader, Object> headers) throws Exception {
        this.getSalesforceSoapAdapter(headers).setPassword(userId, newPassword);
    }

    public void publishTopic(String topicName, String query, String description) throws Exception {
        QueryResult result = this.getSalesforceSoapAdapter().query("SELECT Id FROM PushTopic WHERE Name = '" + topicName + "'");
        if (result.getSize() == 0) {
            SObject pushTopic = new SObject();
            pushTopic.setType("PushTopic");
            pushTopic.setField("ApiVersion", "30.0");
            if (description != null) {
                pushTopic.setField("Description", description);
            }
            pushTopic.setField("Name", topicName);
            pushTopic.setField("Query", query);
            SaveResult[] saveResults = this.getSalesforceSoapAdapter().create(new SObject[]{pushTopic});
            if (!saveResults[0].isSuccess()) {
                throw new SalesforceException(saveResults[0].getErrors()[0].getStatusCode(), saveResults[0].getErrors()[0].getMessage());
            }
        } else {
            SObject pushTopic = result.getRecords()[0];
            if (description != null) {
                pushTopic.setField("Description", description);
            }
            pushTopic.setField("Query", query);
            SaveResult[] saveResults = this.getSalesforceSoapAdapter().update(new SObject[]{pushTopic});
            if (!saveResults[0].isSuccess()) {
                throw new SalesforceException(saveResults[0].getErrors()[0].getStatusCode(), saveResults[0].getErrors()[0].getMessage());
            }
        }
    }

    public GetUserInfoResult getUserInfo() throws Exception {
        return this.getSalesforceSoapAdapter().getUserInfo();
    }

    public StopSourceCallback subscribeTopic(String topic, SourceCallback callback) {
        final String topicName = "/topic" + topic;
        boolean subscribed = false;
        if (this.isReadyToSubscribe()) {
            this.subscribe(topicName, callback);
            subscribed = true;
        }
        subscriptions.add(new Subscription(topicName, callback, subscribed));
        return new StopSourceCallback(){

            public void stop() throws Exception {
                BaseSalesforceConnector.this.getBayeuxClient().unsubscribe(topicName);
            }
        };
    }

    protected void processSubscriptions() {
        boolean resubscribe = false;
        if (this.bc == null) {
            resubscribe = true;
        }
        for (Subscription p : subscriptions) {
            if (!resubscribe && p.isSubscribed()) continue;
            this.subscribe(p.getTopic(), p.getCallback());
        }
    }

    private void subscribe(String topicName, SourceCallback callback) {
        this.getBayeuxClient().subscribe(topicName, new SalesforceBayeuxMessageListener(callback));
    }

    public void setObjectStoreManager(ObjectStoreManager objectStoreManager) {
        this.objectStoreManager = objectStoreManager;
    }

    public void setTimeObjectStore(ObjectStore<? extends Serializable> timeObjectStore) {
        this.timeObjectStore = timeObjectStore;
    }

    public void setRegistry(MuleRegistry registry) {
        this.registry = registry;
    }

    private BatchInfo createBatchAndCompleteRequest(JobInfo jobInfo, List<Map<String, Object>> objects) throws Exception {
        BatchRequest batchRequest = this.getSalesforceRestAdapter().createBatch(jobInfo);
        try {
            batchRequest.addSObjects(SalesforceUtils.toAsyncSObjectList(objects, this.getBatchSobjectMaxDepth()));
            return batchRequest.completeRequest();
        }
        catch (Exception e) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("Problem when completing the request from the batch " + jobInfo.getId() + ", threw " + e.getClass()));
            }
            throw SalesforceExceptionHandlerAdapter.analyzeRestException(e);
        }
    }

    private BatchInfo createBatchForQuery(JobInfo jobInfo, InputStream query) throws AsyncApiException {
        return this.getSalesforceRestAdapter().createBatchFromStream(jobInfo, query);
    }

    private JobInfo createJobInfo(OperationEnum op, String type) throws AsyncApiException {
        return this.createJobInfo(op, type, null, null, null);
    }

    private JobInfo createJobInfo(OperationEnum op, String type, String externalIdFieldName, ContentType contentType, ConcurrencyMode concurrencyMode) throws AsyncApiException {
        JobInfo jobInfo = new JobInfo();
        jobInfo.setOperation(op);
        jobInfo.setObject(type);
        if (externalIdFieldName != null) {
            jobInfo.setExternalIdFieldName(externalIdFieldName);
        }
        if (contentType != null) {
            jobInfo.setContentType(contentType);
        }
        if (concurrencyMode != null) {
            jobInfo.setConcurrencyMode(concurrencyMode);
        }
        return this.getSalesforceRestAdapter().createJob(jobInfo);
    }

    private com.sforce.async.SObject toAsyncSObject(Map<String, Object> map) {
        com.sforce.async.SObject sObject = this.batchSobjectMaxDepth != null ? new com.sforce.async.SObject(this.batchSobjectMaxDepth.intValue()) : new com.sforce.async.SObject();
        for (String key : map.keySet()) {
            Object object = map.get(key);
            if (object != null) {
                if (object instanceof Map) {
                    sObject.setFieldReference(key, this.toAsyncSObject(this.toSObjectMap((Map)object)));
                    continue;
                }
                if (this.isDateField(object)) {
                    sObject.setField(key, this.convertDateToString(object));
                    continue;
                }
                sObject.setField(key, object.toString());
                continue;
            }
            sObject.setField(key, null);
        }
        return sObject;
    }

    protected SObject toSObject(String type, Map<String, Object> map) {
        SObject sObject = new SObject();
        sObject.setType(type);
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            String key = entry.getKey();
            if (key.equals("fieldsToNull")) {
                sObject.setFieldsToNull((String[])entry.getValue());
                continue;
            }
            if (entry.getValue() instanceof Map) {
                sObject.setField(key, (Object)this.toSObject(key, this.toSObjectMap((Map)entry.getValue())));
                continue;
            }
            sObject.setField(key, entry.getValue());
        }
        return sObject;
    }

    protected Map<String, Object> toSObjectMap(Map map) {
        HashMap<String, Object> sObjectMap = new HashMap<String, Object>();
        for (Object key : map.keySet()) {
            sObjectMap.put(key.toString(), map.get(key));
        }
        return sObjectMap;
    }

    private synchronized ObjectStoreHelper getObjectStoreHelper(String username) {
        if (this.objectStoreHelper == null) {
            if (this.timeObjectStore == null) {
                this.timeObjectStore = (ObjectStore)this.registry.lookupObject("_defaultUserObjectStore");
                if (this.timeObjectStore == null) {
                    this.timeObjectStore = this.objectStoreManager.getObjectStore(username, true);
                }
                if (this.timeObjectStore == null) {
                    throw new IllegalArgumentException("Unable to acquire an object store.");
                }
            }
            this.objectStoreHelper = new ObjectStoreHelper(username, this.timeObjectStore);
        }
        return this.objectStoreHelper;
    }

    protected void setConnectionOptions(PartnerConnection connection) {
        Boolean allowFieldTruncationSupport;
        String clientId = this.getClientId();
        if (clientId != null) {
            CallOptions_element callOptions = new CallOptions_element();
            callOptions.setClient(clientId);
            connection.__setCallOptions(callOptions);
        }
        String assignmentRuleId = this.getAssignmentRuleId();
        Boolean useDefaultRule = this.getUseDefaultRule();
        if (assignmentRuleId != null || useDefaultRule != null) {
            AssignmentRuleHeader_element assignmentRule = new AssignmentRuleHeader_element();
            if (assignmentRuleId != null) {
                assignmentRule.setAssignmentRuleId(assignmentRuleId);
            }
            if (useDefaultRule != null) {
                assignmentRule.setUseDefaultRule(useDefaultRule);
            }
            connection.__setAssignmentRuleHeader(assignmentRule);
        }
        if ((allowFieldTruncationSupport = this.getAllowFieldTruncationSupport()) != null) {
            connection.setAllowFieldTruncationHeader(allowFieldTruncationSupport);
        }
    }

    public ObjectStore<? extends Serializable> getTimeObjectStore() {
        return this.timeObjectStore;
    }

    public String getClientId() {
        return this.clientId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public String getAssignmentRuleId() {
        return this.assignmentRuleId;
    }

    public void setAssignmentRuleId(String assignmentRuleId) {
        this.assignmentRuleId = assignmentRuleId;
    }

    public Boolean getUseDefaultRule() {
        return this.useDefaultRule;
    }

    public void setUseDefaultRule(Boolean useDefaultRule) {
        this.useDefaultRule = useDefaultRule;
    }

    public Boolean getAllowFieldTruncationSupport() {
        return this.allowFieldTruncationSupport;
    }

    public void setAllowFieldTruncationSupport(Boolean allowFieldTruncationSupport) {
        this.allowFieldTruncationSupport = allowFieldTruncationSupport;
    }

    public Integer getBatchSobjectMaxDepth() {
        return this.batchSobjectMaxDepth;
    }

    public void setBatchSobjectMaxDepth(Integer batchSobjectMaxDepth) {
        this.batchSobjectMaxDepth = batchSobjectMaxDepth;
    }

    public void setMuleContext(MuleContext context) {
        this.setObjectStoreManager((ObjectStoreManager)context.getRegistry().get("_muleObjectStoreManager"));
        this.setRegistry(context.getRegistry());
    }

    protected boolean isDateField(Object object) {
        return object instanceof Date || object instanceof GregorianCalendar || object instanceof Calendar;
    }

    protected String convertDateToString(Object object) {
        return new DateTime(object).toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void registerTransformers() {
        MuleRegistry muleRegistry = this.registry;
        synchronized (muleRegistry) {
            try {
                if (this.registry.lookupObject(SaveResultToBulkOperationTransformer.class) == null) {
                    this.registry.registerTransformer((Transformer)new SaveResultToBulkOperationTransformer());
                }
                if (this.registry.lookupObject(UpsertResultToBulkOperationTransformer.class) == null) {
                    this.registry.registerTransformer((Transformer)new UpsertResultToBulkOperationTransformer());
                }
            }
            catch (MuleException e) {
                throw new RuntimeException("Exception found trying to register bulk transformers", e);
            }
        }
    }

    public PartnerConnection getSalesforceSoapAdapter() {
        return this.getSalesforceSoapAdapter(new HashMap<SalesforceHeader, Object>());
    }

    public PartnerConnection getSalesforceSoapAdapter(Map<SalesforceHeader, Object> headers) {
        return SalesforceSoapAdapter.adapt(this.getConnection(), headers);
    }

    public BulkConnection getSalesforceRestAdapter() {
        return SalesforceRestAdapter.adapt(this.getBulkConnection());
    }

    private static class Subscription {
        private String topic;
        private SourceCallback callback;
        private boolean subscribed;

        private Subscription(String topic, SourceCallback callback, boolean subscribed) {
            this.topic = topic;
            this.callback = callback;
            this.subscribed = subscribed;
        }

        public SourceCallback getCallback() {
            return this.callback;
        }

        public String getTopic() {
            return this.topic;
        }

        public boolean isSubscribed() {
            return this.subscribed;
        }
    }
}

